[misk-metrics-digester](../../index.md) / [misk.metrics.digester](../index.md) / [SlidingWindowDigest](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`SlidingWindowDigest(windower: `[`Windower`](../-windower/index.md)`, tDigest: () -> `[`T`](index.md#T)`, utcNowClock: `[`Clock`](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html)` = Clock.systemUTC())`

SlidingWindowDigest approximates quantiles of data for a trailing time period. It is thread-safe.

To efficiently store observed data in a mergeable way, t-openDigests are used.
As t-openDigests do not support discarding older data points, the sliding window
aspect is approximated by keeping multiple separate t-openDigests scoped to discrete
overlapping time windows. As a result, quantile data is reported from the most recent window that has ended.

The following example creates a 1 minute sliding window where there are 6 overlapping windows at a given time.
Reported quantiles are at most 10 seconds out of date.
SlidingWindowDigest(Windower(60, 6),  fun() = VeneurDigest())

The following example creates a 10 second sliding window where there are 2 overlapping windows at a given time.
Reported quantiles are at most 5 seconds out of date:
NewSlidingWindowDigest(Windower(10, 2),  fun() = VeneurDigest())

