[misk-metrics-digester](../../index.md) / [misk.metrics.digester](../index.md) / [SlidingWindowDigest](./index.md)

# SlidingWindowDigest

`class SlidingWindowDigest<T : `[`TDigest`](../-t-digest/index.md)`<`[`T`](index.md#T)`>>`

SlidingWindowDigest approximates quantiles of data for a trailing time period. It is thread-safe.

To efficiently store observed data in a mergeable way, t-openDigests are used.
As t-openDigests do not support discarding older data points, the sliding window
aspect is approximated by keeping multiple separate t-openDigests scoped to discrete
overlapping time windows. As a result, quantile data is reported from the most recent window that has ended.

The following example creates a 1 minute sliding window where there are 6 overlapping windows at a given time.
Reported quantiles are at most 10 seconds out of date.
SlidingWindowDigest(Windower(60, 6),  fun() = VeneurDigest())

The following example creates a 10 second sliding window where there are 2 overlapping windows at a given time.
Reported quantiles are at most 5 seconds out of date:
NewSlidingWindowDigest(Windower(10, 2),  fun() = VeneurDigest())

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `SlidingWindowDigest(windower: `[`Windower`](../-windower/index.md)`, tDigest: () -> `[`T`](index.md#T)`, utcNowClock: `[`Clock`](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html)` = Clock.systemUTC())`<br>SlidingWindowDigest approximates quantiles of data for a trailing time period. It is thread-safe. |

### Functions

| Name | Summary |
|---|---|
| [closedDigests](closed-digests.md) | `fun closedDigests(from: `[`ZonedDateTime`](https://docs.oracle.com/javase/8/docs/api/java/time/ZonedDateTime.html)`): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`WindowDigest`](../-window-digest/index.md)`<`[`T`](index.md#T)`>>`<br>Returns all WindowDigests that ended starting from the given time (inclusive). The returned WindowDigest are ordered by their start time. |
| [mergeIn](merge-in.md) | `fun mergeIn(windowDigests: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`WindowDigest`](../-window-digest/index.md)`<`[`T`](index.md#T)`>>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Merges in the data from the given WindowDigests. The given windowDigests should use the same windowing boundaries as this; if they do not then quantiles reported by this sliding window digest may be incorrect. |
| [observe](observe.md) | `fun observe(value: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Adds the given value to all currently open t-openDigests. It is important to note that an observed value is not immediately reflected in calls to Quantile. |
| [openDigests](open-digests.md) | `fun openDigests(gc: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`WindowDigest`](../-window-digest/index.md)`<`[`T`](index.md#T)`>>`<br>Returns all WindowDigests that are currently open, creating new windows if necessary. Older openDigests that ended more than 1 minute earlier are discarded if gc is true. |
| [quantile](quantile.md) | `fun quantile(quantile: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`): `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)<br>Returns estimated value for a quantile. The returned value may not include recently observed values due to how sliding windows are approximated. If no data has been observed then NaN is returned. |
| [snapshot](snapshot.md) | `fun snapshot(quantiles: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`>): `[`Snapshot`](../-snapshot/index.md)<br>Returns a snapshot of estimated values for quantiles, along with the count of observations and their sum. The returned values may not include recent observations due to how sliding windows are approximated. If no data has been observed then a slice of NaNs of having quantiles.count() is returned and NaN is returned for the sum. |
