[misk-metrics-digester](../../index.md) / [misk.metrics.digester](../index.md) / [TDigest](./index.md)

# TDigest

`interface TDigest<T : `[`TDigest`](./index.md)`<`[`T`](index.md#T)`>>`

TDigest abstract common methods for t-digest implementations

### Functions

| Name | Summary |
|---|---|
| [add](add.md) | `abstract fun add(value: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Adds an observed value to the digest. |
| [count](count.md) | `abstract fun count(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the count of values added into the digest. |
| [mergeInto](merge-into.md) | `abstract fun mergeInto(other: `[`T`](index.md#T)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>MergeInto merges the data in this digest into the other digest. The other digest is mutated and must be of the same TDigest type. |
| [proto](proto.md) | `abstract fun proto(): `[`DigestData`](../../com.squareup.digester.protos.service/-digest-data/index.md)<br>Proto returns a representation of the t-digest that can be later reconstituted into an instance of the same type. |
| [quantile](quantile.md) | `abstract fun quantile(quantile: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`): `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)<br>Quantile returns the estimated value at quantile. A given quantile should be in the range of [0,1.0](#). If no data has been added then NaN is returned. |
| [sum](sum.md) | `abstract fun sum(): `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)<br>Returns the sum of all values added into the digest, or NaN if no values have been added. |

### Inheritors

| Name | Summary |
|---|---|
| [FakeDigest](../-fake-digest/index.md) | `class FakeDigest : `[`TDigest`](./index.md)`<`[`FakeDigest`](../-fake-digest/index.md)`>`<br>Simulates VeneurDigest for testing purposes |
| [VeneurDigest](../-veneur-digest/index.md) | `class VeneurDigest : `[`TDigest`](./index.md)`<`[`VeneurDigest`](../-veneur-digest/index.md)`>`<br>Wraps an adapted t-digest implementation from Stripe's Veneur project |
