[misk-redis](../../index.md) / [misk.redis](../index.md) / [Redis](./index.md)

# Redis

`interface Redis`

A Redis client.

### Functions

| Name | Summary |
|---|---|
| [del](del.md) | `abstract fun del(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Deletes a single key.`abstract fun del(vararg keys: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Deletes multiple keys. |
| [get](get.md) | `abstract operator fun get(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): ByteString?`<br>Retrieves the value for the given key as a [ByteString](#). |
| [mget](mget.md) | `abstract fun mget(vararg keys: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ByteString?>`<br>Retrieves the values for the given list of keys. |
| [mset](mset.md) | `abstract fun mset(vararg keyValues: ByteString): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Sets the key value pairs. |
| [set](set.md) | `abstract operator fun set(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: ByteString): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Sets the [ByteString](#) value for the given key.`abstract operator fun set(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, expiryDuration: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, value: ByteString): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Sets the [ByteString](#) value for a key with an expiration date. |

### Inheritors

| Name | Summary |
|---|---|
| [FakeRedis](../-fake-redis/index.md) | `class FakeRedis : `[`Redis`](./index.md)<br>Mimics a Redis instance for testing. |
| [RealRedis](../-real-redis/index.md) | `class RealRedis : `[`Redis`](./index.md)<br>For each command, a Jedis instance is retrieved from the pool and returned once the command has been issued. |
