[misk-redis](../index.md) / [misk.redis](./index.md)

## Package misk.redis

### Types

| Name | Summary |
|---|---|
| [FakeRedis](-fake-redis/index.md) | `class FakeRedis : `[`Redis`](-redis/index.md)<br>Mimics a Redis instance for testing. |
| [RealRedis](-real-redis/index.md) | `class RealRedis : `[`Redis`](-redis/index.md)<br>For each command, a Jedis instance is retrieved from the pool and returned once the command has been issued. |
| [Redis](-redis/index.md) | `interface Redis`<br>A Redis client. |
| [RedisConfig](-redis-config/index.md) | `class RedisConfig : `[`LinkedHashMap`](https://docs.oracle.com/javase/8/docs/api/java/util/LinkedHashMap.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`RedisReplicationGroupConfig`](-redis-replication-group-config/index.md)`>, Config` |
| [RedisModule](-redis-module/index.md) | `class RedisModule : KAbstractModule`<br>Configures a JedisPool to connect to a Redis instance. The use of a JedisPool ensures thread safety. See: https://github.com/xetorthio/jedis/wiki/Getting-started#using-jedis-in-a-multithreaded-environment |
| [RedisNodeConfig](-redis-node-config/index.md) | `data class RedisNodeConfig` |
| [RedisReplicationGroupConfig](-redis-replication-group-config/index.md) | `data class RedisReplicationGroupConfig` |
| [RedisTestModule](-redis-test-module/index.md) | `class RedisTestModule : KAbstractModule` |

### Exceptions

| Name | Summary |
|---|---|
| [RedisConnectionException](-redis-connection-exception/index.md) | `class RedisConnectionException : `[`RuntimeException`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-runtime-exception/index.html) |
