[misk-service](../index.md) / [misk](index.md) / [ServiceModule](./-service-module.md)

# ServiceModule

`inline fun <reified T : Service> ServiceModule(qualifier: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): `[`ServiceModule`](-service-module/index.md)

Returns a [ServiceModule](-service-module/index.md) and hooks up service dependencies and enhancements.

Here's how:

```
Guice.createInjector(object : KAbstractModule() {
  override fun configure() {
    install(ServiceModule<MyService>()
        .dependsOn<MyServiceDependency>())
    install(ServiceModule<MyServiceDependency>())
  }
}
```

Dependencies and services may be optionally annotated:

```
Guice.createInjector(object : KAbstractModule() {
  override fun configure() {
    install(ServiceModule<MyService>(MyAnnotation::class)
        .dependsOn<MyServiceDependency>(AnotherAnnotation::class))
    install(ServiceModule<MyServiceDependency>(AnotherAnnotation::class))
  }
}
```

