[misk-service](../../index.md) / [misk](../index.md) / [ServiceModule](./index.md)

# ServiceModule

`class ServiceModule : KAbstractModule`

# Misk Services

Services in Misk can depend on other services.

### Dependencies

Suppose we have a `DatabaseService` and a `MovieService`, with the `MovieService` depending on
the `DatabaseService`.

```
DatabaseService
  depended on by MovieService
```

When you install a service via this module, start-up and shut-down of its dependencies are
handled automatically, so that a service can only run when the services it depends on are
running. In the example above, the `MovieService` doesn't enter the `STARTING` state until the
`DatabaseService` has entered the `RUNNING` state. Conversely, the `MovieService` must enter the
`TERMINATED` state before the DatabaseService enters the `STOPPING` state.

Dependencies can have their own dependencies, so there's an entire graph to manage of what starts
and stops when.

### Enhancements

Some services exist to enhance the behavior of another service.

For example, a `DatabaseService` may manage a generic connection to a MySQL database, and the
`SchemaMigrationService` may create tables specific to the application.

We treat such enhancements as implementation details of the enhanced service: they depend on the
service, but downstream dependencies like the `MovieService` don't need to know that they exist.

```
DatabaseService
  enhanced by SchemaMigrationService
  depended on by MovieService
```

In the above service graph we start the `DatabaseService` first, the `SchemaMigrationService`
second, and finally the `MovieService`. The `MovieService` doesn't need to express a dependency
on the `SchemaMigrationService`, that happens automatically for enhancements.

### What does this look like?

Instead of using the regular service multi-bindings you might be used to, in the `configure`
block of a Guice [KAbstractModule](#), you would set up the above relationship as follows:

```
override fun configure() {
  install(ServiceModule<SchemaMigrationService())
  install(ServiceModule<DatabaseService>()
      .enhancedBy<SchemaMigrationService>())
  install(ServiceModule<MoviesService>()
      .dependsOn<DatabaseService>())
}
```

### How does this work?

Bindings are hooked up for a [ServiceManager](#) provider, which decorates the service with its
dependencies and enhancements to defer its start up and shut down until its dependent services
are ready.

This service will stall in the `STARTING` state until all upstream services are `RUNNING`.
Symmetrically it stalls in the `STOPPING` state until all dependent services are `TERMINATED`.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ServiceModule(key: Key<out Service>, dependsOn: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<Key<out Service>> = listOf(), enhancedBy: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<Key<out Service>> = listOf())`

# Misk Services

 |

### Properties

| Name | Summary |
|---|---|
| [dependsOn](depends-on.md) | `val dependsOn: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<Key<out Service>>` |
| [enhancedBy](enhanced-by.md) | `val enhancedBy: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<Key<out Service>>` |
| [key](key.md) | `val key: Key<out Service>` |

### Functions

| Name | Summary |
|---|---|
| [configure](configure.md) | `fun configure(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [dependsOn](depends-on.md) | `fun dependsOn(upstream: Key<out Service>): `[`ServiceModule`](./index.md)<br>`fun <T : Service> dependsOn(qualifier: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): `[`ServiceModule`](./index.md) |
| [enhancedBy](enhanced-by.md) | `fun enhancedBy(enhancement: Key<out Service>): `[`ServiceModule`](./index.md)<br>`fun <T : Service> enhancedBy(qualifier: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>? = null): `[`ServiceModule`](./index.md) |
