

### All Types

| Name | Summary |
|---|---|
| [misk.service.CachedTestService](../misk.service/-cached-test-service/index.md) | Test services can derive from CachedTestService if they'd like to reuse the same service for the span of a given runtime. This is helpful when you want to avoid incurring the cost of service startup and shutdown with each test run. |
| [misk.containers.Composer](../misk.containers/-composer/index.md) | [Composer](../misk.containers/-composer/index.md) composes many [Container](../misk.containers/-container/index.md)s together to use in a unit test. |
| [misk.testing.ConcurrentMockTracer](../misk.testing/-concurrent-mock-tracer/index.md) | Extends [MockTracer](#) for use in concurrent environments, such as a web server and test client. Prefer this wherever you'd otherwise use [MockTracer](#). |
| [misk.containers.Container](../misk.containers/-container/index.md) | A [Container](../misk.containers/-container/index.md) creates a Docker container for testing. |
| [org.junit.jupiter.api.extension.ExtensionContext](../misk.testing/org.junit.jupiter.api.extension.-extension-context/index.md) (extensions in package misk.testing) |  |
| [misk.testing.ExternalDependency](../misk.testing/-external-dependency/index.md) | An external dependency of the Misk Application that needs to be started for test, like Redis, Vitess, MySQL, SQS, etc. |
| [misk.time.FakeClock](../misk.time/-fake-clock/index.md) |  |
| [misk.time.FakeClockModule](../misk.time/-fake-clock-module/index.md) |  |
| [misk.web.FakeHttpCall](../misk.web/-fake-http-call/index.md) |  |
| [misk.cloud.fake.security.keys.FakeKeyManagementModule](../misk.cloud.fake.security.keys/-fake-key-management-module/index.md) |  |
| [misk.cloud.fake.security.keys.FakeKeyService](../misk.cloud.fake.security.keys/-fake-key-service/index.md) |  |
| [misk.random.FakeRandom](../misk.random/-fake-random/index.md) |  |
| [misk.random.FakeRandomModule](../misk.random/-fake-random-module/index.md) |  |
| [misk.concurrent.FakeScheduledExecutorService](../misk.concurrent/-fake-scheduled-executor-service/index.md) | ScheduledExecutorService for testing that runs in the current thread and is triggered using the `tick()` method. An injected [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html) is used to decide whether to execute a scheduled task. |
| [misk.services.FakeService](../misk.services/-fake-service/index.md) |  |
| [misk.services.FakeServiceModule](../misk.services/-fake-service-module/index.md) |  |
| [misk.concurrent.FakeSleeper](../misk.concurrent/-fake-sleeper/index.md) | [Sleeper](#) for testing that blocks threads calling [sleep](../misk.concurrent/-fake-sleeper/sleep.md), and checks whether the threads should wake using the [tick](../misk.concurrent/-fake-sleeper/tick.md) method. An injected [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html) is used to decide whether to wake a thread. |
| [misk.concurrent.FakeSleeperModule](../misk.concurrent/-fake-sleeper-module/index.md) |  |
| [misk.random.FakeThreadLocalRandom](../misk.random/-fake-thread-local-random/index.md) |  |
| [misk.time.FakeTickerModule](../misk.time/-fake-ticker-module/index.md) |  |
| [misk.web.FakeWebSocketListener](../misk.web/-fake-web-socket-listener/index.md) |  |
| [misk.logging.LogCollector](../misk.logging/-log-collector/index.md) | Collects log messages so they may be asserted on for testing. |
| [misk.logging.LogCollectorModule](../misk.logging/-log-collector-module/index.md) |  |
| [misk.logging.LogCollectorService](../misk.logging/-log-collector-service.md) | Marker interface for the service that produces a [LogCollector](../misk.logging/-log-collector/index.md). |
| [misk.testing.MiskExternalDependency](../misk.testing/-misk-external-dependency/index.md) |  |
| [misk.testing.MiskTest](../misk.testing/-misk-test/index.md) | Annotate your test classes with `@MiskTest` to have fields annotated with `@Inject` initialized. Provide modules to be installed by annotating a [Module](#) field in your test class with [MiskTestModule](../misk.testing/-misk-test-module/index.md). This can be a compound module, composed using [Modules.combine](#). |
| [misk.MiskTestingServiceModule](../misk/-misk-testing-service-module/index.md) | [MiskTestingServiceModule](../misk/-misk-testing-service-module/index.md) should be installed in unit testing environments. |
| [misk.testing.MiskTestModule](../misk.testing/-misk-test-module/index.md) |  |
| [misk.mockito.Mockito](../misk.mockito/-mockito/index.md) |  |
| [misk.testing.MockTracingBackendModule](../misk.testing/-mock-tracing-backend-module/index.md) |  |
| [misk.testing.TemporaryFolder](../misk.testing/-temporary-folder/index.md) | A temporary folder for use by a given test |
| [misk.testing.TemporaryFolderModule](../misk.testing/-temporary-folder-module/index.md) |  |
| [misk.web.WebTestingModule](../misk.web/-web-testing-module/index.md) | A module that starts an embedded Jetty web server configured for testing. The server supports both plaintext and TLS. |
