[misk-testing](../../index.md) / [misk.concurrent](../index.md) / [FakeScheduledExecutorService](./index.md)

# FakeScheduledExecutorService

`@Singleton class FakeScheduledExecutorService : `[`ScheduledExecutorService`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ScheduledExecutorService.html)`, `[`ExecutorService`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ExecutorService.html)

ScheduledExecutorService for testing that runs in the current thread and is triggered using the
`tick()` method. An injected [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html) is used to decide whether to execute a scheduled task.

This service must always "catch up" to the clock, so fixed rate and fixed delay jobs are not different.

### Types

| Name | Summary |
|---|---|
| [ScheduledFutureTask](-scheduled-future-task/index.md) | `inner class ScheduledFutureTask<V> : `[`FutureTask`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/FutureTask.html)`<`[`V`](-scheduled-future-task/index.md#V)`>, `[`ScheduledFuture`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ScheduledFuture.html)`<`[`V`](-scheduled-future-task/index.md#V)`>` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `FakeScheduledExecutorService(clock: `[`Clock`](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html)`)`<br>ScheduledExecutorService for testing that runs in the current thread and is triggered using the `tick()` method. An injected [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html) is used to decide whether to execute a scheduled task. |

### Functions

| Name | Summary |
|---|---|
| [isShutdown](is-shutdown.md) | `fun isShutdown(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [schedule](schedule.md) | `fun schedule(command: `[`Runnable`](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)`, delay: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`ScheduledFuture`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ScheduledFuture.html)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`>`<br>`fun <V> schedule(callable: `[`Callable`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Callable.html)`<`[`V`](schedule.md#V)`>, delay: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`ScheduledFuture`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ScheduledFuture.html)`<`[`V`](schedule.md#V)`>` |
| [scheduleAtFixedRate](schedule-at-fixed-rate.md) | `fun scheduleAtFixedRate(command: `[`Runnable`](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)`, initialDelay: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, period: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`ScheduledFuture`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ScheduledFuture.html)`<*>` |
| [scheduleWithFixedDelay](schedule-with-fixed-delay.md) | `fun scheduleWithFixedDelay(command: `[`Runnable`](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)`, initialDelay: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, delay: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`ScheduledFuture`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ScheduledFuture.html)`<*>` |
| [shutdown](shutdown.md) | `fun shutdown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [tick](tick.md) | `fun tick(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Check the current time on the clock and run any scheduled tasks that are due. |
