[misk-testing](../../index.md) / [misk.concurrent](../index.md) / [FakeSleeper](./index.md)

# FakeSleeper

`@Singleton class FakeSleeper : Sleeper`

[Sleeper](#) for testing that blocks threads calling [sleep](sleep.md), and checks whether the threads should
wake using the [tick](tick.md) method. An injected [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html) is used to decide whether to wake a thread.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `FakeSleeper(clock: `[`Clock`](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html)`)`<br>[Sleeper](#) for testing that blocks threads calling [sleep](sleep.md), and checks whether the threads should wake using the [tick](tick.md) method. An injected [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html) is used to decide whether to wake a thread. |

### Functions

| Name | Summary |
|---|---|
| [lastSleepDuration](last-sleep-duration.md) | `fun lastSleepDuration(): `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`?`<br>Returns the last duration [FakeSleeper](./index.md) was called with. This is thread-safe, but the value may not be meaningful if the sleeper is being used concurrently. |
| [sleep](sleep.md) | `fun sleep(duration: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [sleepCount](sleep-count.md) | `fun sleepCount(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the total number of times the [FakeSleeper](./index.md) has been called. This is thread-safe, but the value may not be meaningful if the sleeper is being used concurrently. |
| [tick](tick.md) | `fun tick(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Check the current time and triggers any sleeping threads that are due to be awoken. |
| [waitForSleep](wait-for-sleep.md) | `fun waitForSleep(numThreads: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Blocks until the given number of threads are asleep (as a result of calling [sleep](sleep.md) on this [FakeSleeper](./index.md)). |
