[misk-testing](../../index.md) / [misk.containers](../index.md) / [Container](./index.md)

# Container

`data class Container`

A [Container](./index.md) creates a Docker container for testing.

Tests provide a lambda to build a [CreateContainerCmd](#). The [createCmd](create-cmd.md) lambda must set
[CreateContainerCmd.withName](#) and [CreateContainerCmd.withImage](#). All other fields are
optional. The [Composer](../-composer/index.md) takes care of setting up the network.

There may be a need to configure your container between the creation and start steps.
[beforeStartHook](before-start-hook.md) provides you with an id to your container allowing you to
manipulate as necessary before the command/entrypoint is invoked.

See [Composer](../-composer/index.md) for an example.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Container(createCmd: CreateContainerCmd.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`)``Container(createCmd: CreateContainerCmd.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, beforeStartHook: (docker: DockerClient, id: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`)`<br>A [Container](./index.md) creates a Docker container for testing. |

### Properties

| Name | Summary |
|---|---|
| [beforeStartHook](before-start-hook.md) | `val beforeStartHook: (docker: DockerClient, id: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [createCmd](create-cmd.md) | `val createCmd: CreateContainerCmd.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
