[misk-testing](../../index.md) / [misk.logging](../index.md) / [LogCollector](./index.md)

# LogCollector

`interface LogCollector`

Collects log messages so they may be asserted on for testing.

To use it, add the [LogCollectorModule](../-log-collector-module/index.md) to your test. You’ll need `@MiskTest` with services
started because this uses a service to install a log appender for the duration of the test.

In your test method you should perform some action that logs, then use an injected `logCollector`
to verify that the expected logs were emitted:

```
@MiskTest(startService = true)
class MyTest {
  @MiskTestModule
  val module = Modules.combine(
      MiskServiceModule(),
      LogCollectorModule(),
      ...
  )

  @Inject lateinit var logCollector: LogCollector

  @Test
  fun test() {
    someMethodThatLogs()
    assertThat(logCollector.takeMessages()).containsExactly("this is the only logged message!")
  }
}
```

Use the optional parameters of [takeMessages](take-messages.md) to constrain which log messages are returned.

### Functions

| Name | Summary |
|---|---|
| [takeEvent](take-event.md) | `abstract fun takeEvent(loggerClass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>? = null, minLevel: Level = Level.INFO, pattern: `[`Regex`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.text/-regex/index.html)`? = null): ILoggingEvent`<br>Waits until a matching event is logged, and returns it. The returned event and all preceding events are also removed. |
| [takeEvents](take-events.md) | `abstract fun takeEvents(loggerClass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>? = null, minLevel: Level = Level.INFO, pattern: `[`Regex`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.text/-regex/index.html)`? = null): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ILoggingEvent>`<br>Removes all currently-collected log events and returns those that match the requested criteria. |
| [takeMessage](take-message.md) | `abstract fun takeMessage(loggerClass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>? = null, minLevel: Level = Level.INFO, pattern: `[`Regex`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.text/-regex/index.html)`? = null): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Waits until a matching event is logged, and returns its message. The returned event and all preceding events are also removed. |
| [takeMessages](take-messages.md) | `abstract fun takeMessages(loggerClass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>? = null, minLevel: Level = Level.INFO, pattern: `[`Regex`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.text/-regex/index.html)`? = null): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>`<br>Removes all currently-collected log messages and returns those that match the requested criteria. |
