[misk-testing](../../index.md) / [misk.service](../index.md) / [CachedTestService](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`CachedTestService()`

Test services can derive from CachedTestService
if they'd like to reuse the same service for the span
of a given runtime. This is helpful when you want to avoid
incurring the cost of service startup and shutdown with
each test run.

NOTE: The caching is only useful if the implementing service
references a shared instance of their underlying resources.
A common way to do this is to leverage a companion object.

Example:

**Singleton**

class TestService : CachedTestService() {
override fun actualStartup() {
    service.start()
}



override fun actualShutdown() {
    service.stop()
}



companion object {
    private val service = Service()
}
}



Sharing the same underlying resources also means that
your tests need to be more conscious about accessing
resources scoped uniquely to that test run, or else
making sure that they cleanup resources before they're run.
This is similar to how we work with DBs, where either
you run something like truncate tables before your tests,
or you ensure that all your test statements are made
relative to the scope of your test.

