[misk-testing](../../index.md) / [misk.service](../index.md) / [CachedTestService](./index.md)

# CachedTestService

`abstract class CachedTestService : AbstractIdleService`

Test services can derive from CachedTestService
if they'd like to reuse the same service for the span
of a given runtime. This is helpful when you want to avoid
incurring the cost of service startup and shutdown with
each test run.

NOTE: The caching is only useful if the implementing service
references a shared instance of their underlying resources.
A common way to do this is to leverage a companion object.

Example:

**Singleton**

class TestService : CachedTestService() {
override fun actualStartup() {
    service.start()
}



override fun actualShutdown() {
    service.stop()
}



companion object {
    private val service = Service()
}
}



Sharing the same underlying resources also means that
your tests need to be more conscious about accessing
resources scoped uniquely to that test run, or else
making sure that they cleanup resources before they're run.
This is similar to how we work with DBs, where either
you run something like truncate tables before your tests,
or you ensure that all your test statements are made
relative to the scope of your test.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `CachedTestService()`<br>Test services can derive from CachedTestService if they'd like to reuse the same service for the span of a given runtime. This is helpful when you want to avoid incurring the cost of service startup and shutdown with each test run. |

### Functions

| Name | Summary |
|---|---|
| [actualShutdown](actual-shutdown.md) | `abstract fun actualShutdown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Actually shuts the service down. This will be invoked once per runtime. |
| [actualStartup](actual-startup.md) | `abstract fun actualStartup(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Actually starts the service up. This will be invoked once per runtime. |
| [shutDown](shut-down.md) | `fun shutDown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [startUp](start-up.md) | `fun startUp(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
