[misk-testing](../../index.md) / [misk.web](../index.md) / [FakeHttpCall](./index.md)

# FakeHttpCall

`data class FakeHttpCall : HttpCall`

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `FakeHttpCall(url: HttpUrl = "https://example.com/".toHttpUrl(), linkLayerLocalAddress: SocketAddress = SocketAddress.Network("1.2.3.4", 56789), dispatchMechanism: DispatchMechanism = DispatchMechanism.GET, requestHeaders: Headers = headersOf(), statusCode: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 200, headersBuilder: Builder = Headers.Builder(), sendTrailers: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, trailersBuilder: Builder = Headers.Builder(), requestBody: BufferedSource? = Buffer(), responseBody: BufferedSink? = Buffer(), webSocket: WebSocket? = null, webSocketListener: WebSocketListener? = null)` |

### Properties

| Name | Summary |
|---|---|
| [dispatchMechanism](dispatch-mechanism.md) | `val dispatchMechanism: DispatchMechanism` |
| [headersBuilder](headers-builder.md) | `val headersBuilder: Builder` |
| [linkLayerLocalAddress](link-layer-local-address.md) | `val linkLayerLocalAddress: SocketAddress` |
| [requestBody](request-body.md) | `var requestBody: BufferedSource?` |
| [requestHeaders](request-headers.md) | `val requestHeaders: Headers` |
| [responseBody](response-body.md) | `var responseBody: BufferedSink?` |
| [responseHeaders](response-headers.md) | `val responseHeaders: Headers` |
| [sendTrailers](send-trailers.md) | `var sendTrailers: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [statusCode](status-code.md) | `var statusCode: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [trailersBuilder](trailers-builder.md) | `val trailersBuilder: Builder` |
| [url](url.md) | `val url: HttpUrl` |
| [webSocket](web-socket.md) | `var webSocket: WebSocket?` |
| [webSocketListener](web-socket-listener.md) | `var webSocketListener: WebSocketListener?` |

### Functions

| Name | Summary |
|---|---|
| [addResponseHeaders](add-response-headers.md) | `fun addResponseHeaders(headers: Headers): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [initWebSocketListener](init-web-socket-listener.md) | `fun initWebSocketListener(webSocketListener: WebSocketListener): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [putRequestBody](put-request-body.md) | `fun putRequestBody(requestBody: BufferedSource): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [putResponseBody](put-response-body.md) | `fun putResponseBody(responseBody: BufferedSink): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [putWebSocket](put-web-socket.md) | `fun putWebSocket(webSocket: WebSocket): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [requireTrailers](require-trailers.md) | `fun requireTrailers(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setResponseHeader](set-response-header.md) | `fun setResponseHeader(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setResponseTrailer](set-response-trailer.md) | `fun setResponseTrailer(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [takeRequestBody](take-request-body.md) | `fun takeRequestBody(): BufferedSource?` |
| [takeResponseBody](take-response-body.md) | `fun takeResponseBody(): BufferedSink?` |
| [takeWebSocket](take-web-socket.md) | `fun takeWebSocket(): WebSocket?` |
