[misk-transactional-jobqueue](../../index.md) / [misk.jobqueue](../index.md) / [TransactionalJobQueue](index.md) / [enqueue](./enqueue.md)

# enqueue

`abstract fun enqueue(session: Session, gid: Gid<*, *>, queueName: QueueName, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, idempotenceKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = UUID.randomUUID().toString(), deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = mapOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Enqueues a job to the database shard associated with the given entity group. Will
throw an exception if the session is associated with a different entity group.

### Parameters

`session` - The database session to use in writing the job

`gid` - The id of the entity group with which the job should be associated

`queueName` - the name of the queue on which to place the job

`body` - The body of the job; can be any arbitrary string - it is up to the enqueuer and
consumer to agree on the format of the body

`idempotenceKey` - Client-assigned unique key, useful for application code to detect duplicate work.
Implementations are expected to *not* perform any filtering based on this value, as it carries meaning only for
application code (i.e. any logic around this property should take place in [JobHandler](#)s).
Defaults to a randomly generated UUID when not explicitly set.

`deliveryDelay` - If specified, the job will only become visible to the consumer after
the provided duration. Used for jobs that should delay processing for a period of time.

`attributes` - Arbitrary contextual attributes associated with the job`abstract fun enqueue(session: Session, queueName: QueueName, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, idempotenceKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = UUID.randomUUID().toString(), deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = mapOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Enqueues a job to the primary (unaffiliated) database shard . Will throw an exception if the
session is associated with an entity group.

### Parameters

`session` - The database session to use in writing the job

`queueName` - the name of the queue on which to place the job

`body` - The body of the job; can be any arbitrary string - it is up to the enqueuer and
consumer to agree on the format of the body

`idempotenceKey` - Client-assigned unique key, useful for application code to detect duplicate work.
Implementations are expected to *not* perform any filtering based on this value, as it carries meaning only for
application code (i.e. any logic around this property should take place in [JobHandler](#)s).
Defaults to a randomly generated UUID when not explicitly set.

`deliveryDelay` - If specified, the job will only become visible to the consumer after
the provided duration. Used for jobs that should delay processing for a period of time.

`attributes` - Arbitrary contextual attributes associated with the job