[misk-transactional-jobqueue](../../index.md) / [misk.jobqueue](../index.md) / [TransactionalJobQueue](./index.md)

# TransactionalJobQueue

`interface TransactionalJobQueue`

A [TransactionalJobQueue](./index.md) supports enqueueing messages atomically in conjunction with
making local database updates. With the transactional job queue, messages are written to
a spooling table that is on the same database shard as the application's database entities,
then forwards the messages asynchronously to the actual queueing system. Two variants
of the [enqueue](enqueue.md) operation exist - one which writes to the application's main shard, and
another which writes to the shard on which a given entity group exists. Applications
will typically use tbe second variant, writing jobs to the local shard in the context
of a transaction that modifies the contents of an entity group.

### Functions

| Name | Summary |
|---|---|
| [enqueue](enqueue.md) | `abstract fun enqueue(session: Session, gid: Gid<*, *>, queueName: QueueName, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, idempotenceKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = UUID.randomUUID().toString(), deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = mapOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Enqueues a job to the database shard associated with the given entity group. Will throw an exception if the session is associated with a different entity group.`abstract fun enqueue(session: Session, queueName: QueueName, body: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, idempotenceKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = UUID.randomUUID().toString(), deliveryDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, attributes: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = mapOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Enqueues a job to the primary (unaffiliated) database shard . Will throw an exception if the session is associated with an entity group. |
