

### All Types

| Name | Summary |
|---|---|
| [misk.security.authz.AccessAnnotationEntry](../misk.security.authz/-access-annotation-entry/index.md) | Use this to alias an annotation to a set of services and capabilities. This can be used to decouple code that needs access control from the policy that defines it. |
| [misk.security.authz.AccessControlModule](../misk.security.authz/-access-control-module/index.md) | Install support for performing access control checks for actions based on the incoming caller. |
| [misk.security.authz.AccessInterceptor](../misk.security.authz/-access-interceptor/index.md) |  |
| [misk.Action](../misk/-action/index.md) |  |
| [misk.web.exceptions.ActionExceptionLogLevelConfig](../misk.web.exceptions/-action-exception-log-level-config/index.md) | Configures the log [Level](#) for an ActionException. |
| [misk.scope.ActionScope](../misk.scope/-action-scope/index.md) |  |
| [misk.scope.executor.ActionScopedExecutorService](../misk.scope.executor/-action-scoped-executor-service/index.md) | Wraps a [ListeningExecutorService](#) to propagate the current action scope to any tasks submitted by the current thread |
| [misk.scope.ActionScopedProvider](../misk.scope/-action-scoped-provider/index.md) | An [ActionScopedProvider](../misk.scope/-action-scoped-provider/index.md) is implemented by components and application code that wants provide contextual information based on an incoming request, job data, etc. |
| [misk.scope.ActionScopedProviderModule](../misk.scope/-action-scoped-provider-module/index.md) | Module used by components and applications to provide [ActionScoped](#) context objects |
| [misk.clustering.weights.ActiveClusterWeight](../misk.clustering.weights/-active-cluster-weight/index.md) | A static [ClusterWeightProvider](../misk.clustering.weights/-cluster-weight-provider/index.md) that always returns 100 |
| [misk.clustering.weights.ActiveClusterWeightModule](../misk.clustering.weights/-active-cluster-weight-module/index.md) | Provides an [ActiveClusterWeight](../misk.clustering.weights/-active-cluster-weight/index.md) |
| [misk.web.dashboard.AdminDashboard](../misk.web.dashboard/-admin-dashboard/index.md) | Dashboard Annotation used for all tabs bound in the Misk Admin Dashboard |
| [misk.web.dashboard.AdminDashboardAccess](../misk.web.dashboard/-admin-dashboard-access/index.md) |  |
| [misk.web.dashboard.AdminDashboardModule](../misk.web.dashboard/-admin-dashboard-module/index.md) | Installs default Admin Dashboard that runs at multibound DashboardHomeUrl |
| [misk.web.dashboard.AdminDashboardTestingModule](../misk.web.dashboard/-admin-dashboard-testing-module/index.md) |  |
| [misk.sampling.AlwaysSampler](../misk.sampling/-always-sampler/index.md) | Sampler that always invokes an action |
| [misk.ApplicationInterceptor](../misk/-application-interceptor/index.md) |  |
| [misk.config.AppName](../misk.config/-app-name/index.md) |  |
| [misk.config.AppNameModule](../misk.config/-app-name-module/index.md) | Binds a @AppName String to the provided application name |
| [misk.client.BeginClientCallChain](../misk.client/-begin-client-call-chain/index.md) |  |
| [okio.BufferedSource](../misk.okio/okio.-buffered-source/index.md) (extensions in package misk.okio) |  |
| [misk.moshi.okio.ByteStringAdapter](../misk.moshi.okio/-byte-string-adapter/index.md) | JSON adapter converting [ByteString](#)s as base64 encoded strings |
| [misk.Chain](../misk/-chain/index.md) |  |
| [misk.security.ssl.CipherSuites](../misk.security.ssl/-cipher-suites/index.md) |  |
| [misk.web.formatter.ClassNameFormatter](../misk.web.formatter/-class-name-formatter/index.md) |  |
| [misk.client.ClientAction](../misk.client/-client-action/index.md) | Metadata about a client action |
| [misk.client.ClientApplicationInterceptor](../misk.client/-client-application-interceptor/index.md) | Intercepts client side calls at the application level, able to view and modify the outgoing request arguments, and to observe the application level response |
| [misk.security.ssl.ClientCertChain](../misk.security.ssl/-client-cert-chain/index.md) | Qualifier annotation for an [ActionScoped](#) array of [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html)s containing the certificate chain provided by the client (if any) |
| [misk.security.ssl.ClientCertIssuer](../misk.security.ssl/-client-cert-issuer/index.md) | Qualifier annotation for an [ActionScoped](../misk.security.cert/-x500-name/index.md) containing the issuer of the client cert |
| [misk.security.ssl.ClientCertSubject](../misk.security.ssl/-client-cert-subject/index.md) | Qualifier annotation for an [ActionScoped](../misk.security.cert/-x500-name/index.md) containing the subject of the client cert |
| [misk.client.ClientChain](../misk.client/-client-chain/index.md) |  |
| [misk.client.ClientMetricsInterceptor](../misk.client/-client-metrics-interceptor/index.md) |  |
| [misk.client.ClientNetworkChain](../misk.client/-client-network-chain/index.md) |  |
| [misk.client.ClientNetworkInterceptor](../misk.client/-client-network-interceptor/index.md) | Intercepts client side calls at the application level, able to view and modify the outgoing HTTP request and observe the returned HTTP response |
| [misk.client.ClientNetworkInterceptorsModule](../misk.client/-client-network-interceptors-module/index.md) | The common set of [ClientNetworkInterceptor](../misk.client/-client-network-interceptor/index.md)s for all misk apps. |
| [misk.clustering.weights.ClusterWeightProvider](../misk.clustering.weights/-cluster-weight-provider/index.md) | Provides the current weight assigned to the cluster. |
| [misk.clustering.weights.ClusterWeightService](../misk.clustering.weights/-cluster-weight-service.md) | A marker interface for the Service that produces the [ClusterWeightProvider](../misk.clustering.weights/-cluster-weight-provider/index.md). |
| [misk.config.Config](../misk.config/-config.md) |  |
| [misk.web.metadata.ConfigMetadataAction](../misk.web.metadata/-config-metadata-action/index.md) |  |
| [misk.config.ConfigModule](../misk.config/-config-module/index.md) |  |
| [misk.web.dashboard.DashboardHomeUrl](../misk.web.dashboard/-dashboard-home-url/index.md) | Url to link to for the home button in the dashboard navbar 1 [DashboardHomeUrl](../misk.web.dashboard/-dashboard-home-url/index.md) should be bound per dashboard |
| [misk.web.metadata.DashboardMetadataAction](../misk.web.metadata/-dashboard-metadata-action/index.md) | Serve metadata related to a Misk-Web Dashboard |
| [misk.web.dashboard.DashboardModule](../misk.web.dashboard/-dashboard-module/index.md) | Support Misk-Web Dashboards including the Misk [AdminDashboard](../misk.web.dashboard/-admin-dashboard/index.md) and service specific front end apps |
| [misk.web.dashboard.DashboardNavbarItem](../misk.web.dashboard/-dashboard-navbar-item/index.md) | A list of elements to add to the dashboard navbar Misk-Web's default navbar handles responsive layout of these items so overflow navbar items are included in the drop down menu |
| [misk.web.dashboard.DashboardNavbarStatus](../misk.web.dashboard/-dashboard-navbar-status/index.md) | Banner text to show below the dashboard navbar 0 or 1 [DashboardNavbarStatus](../misk.web.dashboard/-dashboard-navbar-status/index.md) should be bound per dashboard |
| [misk.web.dashboard.DashboardTab](../misk.web.dashboard/-dashboard-tab/index.md) | A [WebTab](../misk.web.dashboard/-web-tab/index.md) with additional fields to bind to a specific Dashboard that has a tabs menu |
| [misk.web.dashboard.DashboardTabProvider](../misk.web.dashboard/-dashboard-tab-provider/index.md) | Sets the tab's authentication capabilities/services by the multibound [AccessAnnotationEntry](../misk.security.authz/-access-annotation-entry/index.md) |
| [misk.tasks.DelayedTask](../misk.tasks/-delayed-task/index.md) | A [DelayedTask](../misk.tasks/-delayed-task/index.md) is a task that runs in  the future |
| [misk.environment.Deployment](../misk.environment/-deployment/index.md) | Deployment describes the context in which the application is running |
| [misk.environment.DeploymentModule](../misk.environment/-deployment-module/index.md) | Binds [Deployment](../misk.environment/-deployment/index.md) and [Env](../misk.environment/-env/index.md) to make them available to services and actions |
| [misk.security.authz.DevelopmentOnly](../misk.security.authz/-development-only/index.md) |  |
| [misk.web.DispatchMechanism](../misk.web/-dispatch-mechanism/index.md) | Describes how an action is processed. This is like the HTTP method but has special cases for web sockets and gRPC. These protocols layer on top of HTTP methods and have different semantics. |
| [misk.environment.Env](../misk.environment/-env/index.md) | The raw environment name. The set of possibilities is unbounded so this should rarely be used. Instead, use the Deployment type for behavior based on characteristics of an environment. |
| [misk.environment.EnvironmentModule](../misk.environment/-environment-module/index.md) | Binds [Environment](#) to make it available to services and actions |
| [misk.client.EnvoyClientEndpointProvider](../misk.client/-envoy-client-endpoint-provider/index.md) | Envoy configuration provider per endpoint that misk clients can customize to their needs. |
| [misk.environment.EnvVarLoader](../misk.environment/-env-var-loader/index.md) | Loads an environment variable value. |
| [misk.web.exceptions.ExceptionHandlingInterceptor](../misk.web.exceptions/-exception-handling-interceptor/index.md) | Converts and logs application and component level dispatch exceptions into the appropriate response format. Allows application and component code to control how exceptions are represented to clients; for example by setting the status code appropriately, or by returning a specialized response format specific to the error. Components can control how exceptions are mapped by installing [ExceptionMapper](../misk.web.exceptions/-exception-mapper/index.md) via the [ExceptionMapperModule](../misk.web.exceptions/-exception-mapper-module/index.md) |
| [misk.web.exceptions.ExceptionMapper](../misk.web.exceptions/-exception-mapper/index.md) | Maps an exception to a [Response](#) |
| [misk.web.exceptions.ExceptionMapperModule](../misk.web.exceptions/-exception-mapper-module/index.md) | Binds a [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) to an [ExceptionMapper](../misk.web.exceptions/-exception-mapper/index.md). |
| [misk.web.exceptions.ExceptionMapperResolver](../misk.web.exceptions/-exception-mapper-resolver/index.md) |  |
| [misk.concurrent.ExecutorServiceModule](../misk.concurrent/-executor-service-module/index.md) | Install this to bind an executor service with [annotation](#). The executor service will be automatically shut down when the service shuts down. |
| [misk.concurrent.ExplicitReleaseBlockingQueue](../misk.concurrent/-explicit-release-blocking-queue/index.md) | An [ExplicitReleaseBlockingQueue](../misk.concurrent/-explicit-release-blocking-queue/index.md) is a [BlockingQueue](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/BlockingQueue.html) that only returns elements from [BlockingQueue.take](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/BlockingQueue.html#take()), [BlockingQueue.poll](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/BlockingQueue.html#poll(long, java.util.concurrent.TimeUnit)), and [BlockingQueue.peek](https://docs.oracle.com/javase/8/docs/api/java/util/Queue.html#peek()) after a call to [ExplicitReleaseBlockingQueue.release](../misk.concurrent/-explicit-release-blocking-queue/release.md). Used by tests that want to explicitly control when pollers receive queued items. |
| [misk.concurrent.ExplicitReleaseDelayQueue](../misk.concurrent/-explicit-release-delay-queue/index.md) | An [ExplicitReleaseDelayQueue](../misk.concurrent/-explicit-release-delay-queue/index.md) is an [ExplicitReleaseBlockingQueue](../misk.concurrent/-explicit-release-blocking-queue/index.md) that release elements in the order in which they expire |
| [misk.security.authz.FakeCallerAuthenticator](../misk.security.authz/-fake-caller-authenticator/index.md) | A caller authenticator that blindly trusts HTTP headers. Unsafe for production use. |
| [misk.clustering.weights.FakeClusterWeight](../misk.clustering.weights/-fake-cluster-weight/index.md) | A [ClusterWeightProvider](../misk.clustering.weights/-cluster-weight-provider/index.md) for testing |
| [misk.clustering.weights.FakeClusterWeightModule](../misk.clustering.weights/-fake-cluster-weight-module/index.md) | Provides a [FakeClusterWeight](../misk.clustering.weights/-fake-cluster-weight/index.md) for testing |
| [misk.environment.FakeEnvVarModule](../misk.environment/-fake-env-var-module/index.md) | Binds a [EnvVarLoader](../misk.environment/-env-var-loader/index.md) for tests. Tests can contribute values through the `@ForEnvVars Map<String, String>` binding. |
| [misk.tokens.FakeTokenGenerator](../misk.tokens/-fake-token-generator/index.md) |  |
| [misk.tokens.FakeTokenGeneratorModule](../misk.tokens/-fake-token-generator-module/index.md) |  |
| [misk.web.actions.FakeWebSocket](../misk.web.actions/-fake-web-socket/index.md) |  |
| [misk.web.metadata.Field](../misk.web.metadata/-field/index.md) |  |
| [misk.flags.Flag](../misk.flags/-flag/index.md) |  |
| [misk.flags.Flags](../misk.flags/-flags/index.md) |  |
| [misk.flags.FlagsModule](../misk.flags/-flags-module/index.md) | Installs support for flag. Applications should inherit from this module and override [configureFlags](../misk.flags/-flags-module/configure-flags.md), calling the various bindXXXFlags methods to make flag variables available |
| [misk.flags.FlagStore](../misk.flags/-flag-store/index.md) | Applications register their interest in monitoring flags through the [registerFlag](../misk.flags/-flag-store/register-flag.md) calls. If registration and watching requires contacting a remote service (e.g. a flag service, Zookeeper, etc), this should be done asynchronously so that multiple flags can be registered in parallel, with the [Flag.get](../misk.flags/-flag/get.md) calls blocking until the registration for that flag is complete. An application can also call [awaitRegistrationsComplete](../misk.flags/-flag-store/await-registrations-complete.md) to block until all pending registrations have completed, allowing e.g. the application to avoid processing incoming requests until all of its flags are available and watched |
| [misk.time.ForceUtcTimeZoneService](../misk.time/-force-utc-time-zone-service/index.md) | Forces the default JVM timezone to UTC. |
| [misk.environment.ForEnvVars](../misk.environment/-for-env-vars/index.md) |  |
| [misk.web.marshal.GenericMarshallers](../misk.web.marshal/-generic-marshallers/index.md) | Handles generic marshalling, for cases where the action doesn't explicitly specify return content |
| [misk.web.marshal.GenericUnmarshallers](../misk.web.marshal/-generic-unmarshallers/index.md) | Handles generic unmarshalling, for cases where the action can accept anything |
| [misk.client.GrpcClientModule](../misk.client/-grpc-client-module/index.md) | Creates a gRPC client given a Wire-generated interface and HTTP configuration. |
| [misk.healthchecks.HealthCheck](../misk.healthchecks/-health-check/index.md) | Allows users to define custom health checks. An app with a failing HealthCheck will fail the readiness check in [ReadinessCheckAction](../misk.web.actions/-readiness-check-action/index.md), indicating that the app should not accept traffic. |
| [misk.healthchecks.HealthStatus](../misk.healthchecks/-health-status/index.md) |  |
| [misk.metrics.Histogram](../misk.metrics/-histogram/index.md) |  |
| [misk.metrics.HistogramRegistry](../misk.metrics/-histogram-registry/index.md) | Skeleton to create a new histogram. |
| [misk.web.HttpCall](../misk.web/-http-call/index.md) | A live HTTP call from a client for use by a chain of network interceptors. |
| [misk.client.HttpClientConfigUrlProvider](../misk.client/-http-client-config-url-provider/index.md) | Calculates the url for an http client config, which can differ depending on if the client is envoy-based or connects directly. |
| [misk.client.HttpClientEndpointConfig](../misk.client/-http-client-endpoint-config/index.md) |  |
| [misk.client.HttpClientEnvoyConfig](../misk.client/-http-client-envoy-config/index.md) |  |
| [misk.client.HttpClientFactory](../misk.client/-http-client-factory/index.md) |  |
| [misk.client.HttpClientModule](../misk.client/-http-client-module/index.md) | Provides an [OkHttpClient](#) and [ProtoMessageHttpClient](../misk.client/-proto-message-http-client/index.md) for a peer service |
| [misk.client.HttpClientsConfig](../misk.client/-http-clients-config/index.md) |  |
| [misk.client.HttpClientsConfigModule](../misk.client/-http-clients-config-module/index.md) |  |
| [misk.client.HttpClientSSLConfig](../misk.client/-http-client-s-s-l-config/index.md) |  |
| [misk.flags.memory.InMemoryBooleanFlag](../misk.flags.memory/-in-memory-boolean-flag/index.md) |  |
| [misk.flags.memory.InMemoryDoubleFlag](../misk.flags.memory/-in-memory-double-flag/index.md) |  |
| [misk.flags.memory.InMemoryFlag](../misk.flags.memory/-in-memory-flag/index.md) | In-memory representation of flags, allowing the flag to be programmatically changed by tests |
| [misk.flags.memory.InMemoryFlagStore](../misk.flags.memory/-in-memory-flag-store/index.md) | In memory implementation of a [FlagStore](../misk.flags/-flag-store/index.md), suitable for use in testing |
| [misk.flags.memory.InMemoryFlagStoreModule](../misk.flags.memory/-in-memory-flag-store-module/index.md) |  |
| [misk.flags.memory.InMemoryIntFlag](../misk.flags.memory/-in-memory-int-flag/index.md) |  |
| [misk.flags.memory.InMemoryStringFlag](../misk.flags.memory/-in-memory-string-flag/index.md) |  |
| [misk.moshi.time.InstantAdapter](../misk.moshi.time/-instant-adapter/index.md) |  |
| [misk.web.actions.InternalErrorAction](../misk.web.actions/-internal-error-action/index.md) |  |
| [misk.web.interceptors.InternalErrorInterceptorFactory](../misk.web.interceptors/-internal-error-interceptor-factory/index.md) |  |
| [misk.client.JettyPortPeerClientModule](../misk.client/-jetty-port-peer-client-module/index.md) | For testing. |
| [misk.web.jetty.JettyService](../misk.web.jetty/-jetty-service/index.md) |  |
| [misk.flags.JsonFlag](../misk.flags/-json-flag/index.md) |  |
| [misk.web.marshal.JsonMarshaller](../misk.web.marshal/-json-marshaller/index.md) |  |
| [misk.web.marshal.JsonUnmarshaller](../misk.web.marshal/-json-unmarshaller/index.md) |  |
| [misk.security.keys.KeyService](../misk.security.keys/-key-service/index.md) | Handles encryption and decryption using keys stored in a key management service |
| [kotlin.reflect.KFunction](../misk/kotlin.reflect.-k-function/index.md) (extensions in package misk) |  |
| [misk.clustering.kubernetes.KubernetesClusterModule](../misk.clustering.kubernetes/-kubernetes-cluster-module/index.md) | [KubernetesClusterModule](../misk.clustering.kubernetes/-kubernetes-cluster-module/index.md) installs cluster support based on Kubernetes |
| [misk.clustering.kubernetes.KubernetesConfig](../misk.clustering.kubernetes/-kubernetes-config/index.md) |  |
| [misk.web.actions.LivenessCheckAction](../misk.web.actions/-liveness-check-action/index.md) |  |
| [misk.web.marshal.Marshaller](../misk.web.marshal/-marshaller/index.md) | Marshalls typed kotlin objects into a [ResponseBody](#) |
| [com.squareup.wire.MessageSource](../misk.grpc/com.squareup.wire.-message-source/index.md) (extensions in package misk.grpc) |  |
| [misk.metrics.Metrics](../misk.metrics/-metrics/index.md) | Manages the Prometheus [CollectorRegistry](#). |
| [misk.metrics.MetricsScope](../misk.metrics/-metrics-scope.md) |  |
| [misk.MiskApplication](../misk/-misk-application/index.md) | The entry point for misk applications |
| [misk.security.authz.MiskCallerAuthenticator](../misk.security.authz/-misk-caller-authenticator/index.md) | Interface for determining the current [MiskCaller](#). Typically use an [ActionScoped](#), [ActionScoped](#), etc to determine the caller based on request headers or client certificate information. |
| [misk.MiskCommand](../misk/-misk-command/index.md) | A command to run from the command line. Each command has an associated name and the list of modules to use in initializing the command. Commands can specify optional and required arguments via JCommander annotations. The command line will pick the appropriate command based on the name, create an injector based on that command's modules, use the injector to initialize the command, and then run the command. |
| [misk.MiskCommonServiceModule](../misk/-misk-common-service-module/index.md) | This module has common bindings for all environments (both real and testing). |
| [misk.config.MiskConfig](../misk.config/-misk-config/index.md) |  |
| [misk.MiskRealServiceModule](../misk/-misk-real-service-module/index.md) | Install this module in real environments. |
| [misk.web.MiskWebModule](../misk.web/-misk-web-module/index.md) |  |
| [com.squareup.moshi.Moshi](../misk.moshi/com.squareup.moshi.-moshi/index.md) (extensions in package misk.moshi) |  |
| [misk.moshi.MoshiAdapterModule](../misk.moshi/-moshi-adapter-module/index.md) |  |
| [misk.web.NetworkChain](../misk.web/-network-chain/index.md) |  |
| [misk.web.NetworkInterceptor](../misk.web/-network-interceptor/index.md) |  |
| [misk.web.actions.NotFoundAction](../misk.web.actions/-not-found-action/index.md) |  |
| [misk.web.metadata.OptionalBinder](../misk.web.metadata/-optional-binder/index.md) | https://github.com/google/guice/wiki/FrequentlyAskedQuestions#how-can-i-inject-optional-parameters-into-a-constructor |
| [misk.web.proxy.OptionalBinder](../misk.web.proxy/-optional-binder/index.md) | https://github.com/google/guice/wiki/FrequentlyAskedQuestions#how-can-i-inject-optional-parameters-into-a-constructor |
| [java.nio.file.Path](../misk.io/java.nio.file.-path/index.md) (extensions in package misk.io) |  |
| [misk.web.PathPattern](../misk.web/-path-pattern/index.md) | A path with placeholders for variables. Paths may be constant like `/app/home/` or dynamic like `/user/{username}`. Variables are delimited by curly braces and may specify an optional regex like this: `{username:[a-z]+}`. If no regex is specified the variable is a sequence of non-'/' characters. |
| [misk.client.PeerClientFactory](../misk.client/-peer-client-factory/index.md) | Factory that creates [OkHttpClient](#)s for connecting to another instance of the same application running in the same cluster. |
| [misk.client.PeerClientModule](../misk.client/-peer-client-module/index.md) | Binds a [PeerClientFactory](../misk.client/-peer-client-factory/index.md) that calls peers on the HTTPS port of this process's server, as determined by the SSL port in the [WebConfig](../misk.web/-web-config/index.md). |
| [misk.sampling.PercentSampler](../misk.sampling/-percent-sampler/index.md) | A [Sampler](../misk.sampling/-sampler/index.md) randomly invokes an action based on a sample percentage |
| [misk.web.marshal.PlainTextMarshaller](../misk.web.marshal/-plain-text-marshaller/index.md) |  |
| [misk.web.marshal.PlainTextUnmarshaller](../misk.web.marshal/-plain-text-unmarshaller/index.md) |  |
| [misk.prometheus.PrometheusHistogram](../misk.prometheus/-prometheus-histogram/index.md) |  |
| [misk.prometheus.PrometheusHistogramRegistry](../misk.prometheus/-prometheus-histogram-registry/index.md) |  |
| [misk.prometheus.PrometheusHistogramRegistryModule](../misk.prometheus/-prometheus-histogram-registry-module/index.md) |  |
| [misk.web.marshal.ProtobufMarshaller](../misk.web.marshal/-protobuf-marshaller/index.md) |  |
| [misk.web.marshal.ProtobufUnmarshaller](../misk.web.marshal/-protobuf-unmarshaller/index.md) |  |
| [misk.client.ProtoMessageHttpClient](../misk.client/-proto-message-http-client/index.md) | This helper class is for making HTTP requests to an endpoint that handles protobuf Message classes. |
| [misk.web.actions.ReadinessCheckAction](../misk.web.actions/-readiness-check-action/index.md) |  |
| [misk.environment.RealEnvVarModule](../misk.environment/-real-env-var-module/index.md) | Binds a [EnvVarLoader](../misk.environment/-env-var-loader/index.md) for production |
| [misk.web.interceptors.RebalancingInterceptor](../misk.web.interceptors/-rebalancing-interceptor/index.md) | When we're deploying and redeploying our pods, we want to make sure that clients rebalance onto the new pods. This randomly closes connections so they will be recreated, naturally balancing connections across pods. |
| [misk.tasks.RepeatedTaskQueue](../misk.tasks/-repeated-task-queue/index.md) | A [RepeatedTaskQueue](../misk.tasks/-repeated-task-queue/index.md) runs repeated tasks at a user controlled rate. Internally it uses a [DelayQueue](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/DelayQueue.html) to hold the pending tasks; a background thread pulls the next task from the [DelayQueue](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/DelayQueue.html) and hands it off to an executor service for execution. |
| [misk.tasks.RepeatedTaskQueueConfig](../misk.tasks/-repeated-task-queue-config/index.md) |  |
| [misk.tasks.RepeatedTaskQueueFactory](../misk.tasks/-repeated-task-queue-factory/index.md) |  |
| [misk.tasks.RepeatedTaskQueueMetrics](../misk.tasks/-repeated-task-queue-metrics/index.md) |  |
| [misk.web.interceptors.RequestBodyLoggingInterceptor](../misk.web.interceptors/-request-body-logging-interceptor/index.md) | Logs request and response information for an action. Timing information doesn't count time writing the response to the remote client. |
| [misk.web.interceptors.RequestLoggingInterceptor](../misk.web.interceptors/-request-logging-interceptor/index.md) | Logs request and response information for an action. Timing information doesn't count time writing the response to the remote client. |
| [misk.web.RequestTypes](../misk.web/-request-types/index.md) | Provides a mapping from field name to Type definition given a KType. Useful for processes that want to have a schema definition of a type. For example: used by the WebActions admin dashboard tab to show a statically typed form containing request fields for developers to fill out. Currently only supports Wire request type messages; non-Wire messages return an empty mapping. |
| [misk.web.resources.ResourceEntryFinder](../misk.web.resources/-resource-entry-finder/index.md) |  |
| [okhttp3.Response](../misk.web/okhttp3.-response/index.md) (extensions in package misk.web) |  |
| [misk.web.interceptors.ResponseBodyMarshallerFactory](../misk.web.interceptors/-response-body-marshaller-factory/index.md) |  |
| [misk.tasks.Result](../misk.tasks/-result/index.md) |  |
| [misk.sampling.Sampler](../misk.sampling/-sampler/index.md) |  |
| [misk.config.Secret](../misk.config/-secret/index.md) | Type for any secrets that need to be loaded as reference in their config file. Secret addresses should use format specified in [misk.resources.ResourceLoader](#). |
| [misk.web.metadata.ServiceMetadata](../misk.web.metadata/-service-metadata/index.md) |  |
| [misk.web.metadata.ServiceMetadataAction](../misk.web.metadata/-service-metadata-action/index.md) | Service Metadata used for front end dashboards including App Name and Misk.Environment |
| [misk.concurrent.Sleeper](../misk.concurrent/-sleeper/index.md) | Abstraction for Thread.sleep() that allows for testing. |
| [misk.web.SocketAddress](../misk.web/-socket-address/index.md) | Information about the socket on which a HTTP call arrived. |
| [misk.web.resources.StaticResourceAction](../misk.web.resources/-static-resource-action/index.md) | StaticResourceAction This data class is used with Guice multibindings. Register instances by calling `multibind()` in a `KAbstractModule`: |
| [misk.web.resources.StaticResourceEntry](../misk.web.resources/-static-resource-entry/index.md) | This data class is used with Guice multibindings. Register instances by calling `multibind()` in a `KAbstractModule`: |
| [misk.tasks.Status](../misk.tasks/-status/index.md) |  |
| [misk.web.actions.StatusAction](../misk.web.actions/-status-action/index.md) | Returns the current status of the service for programmatic tools that want to query for the current state of the server |
| [kotlin.String](../misk.web/kotlin.-string/index.md) (extensions in package misk.web) |  |
| [misk.web.jetty.ThreadPoolQueueMetrics](../misk.web.jetty/-thread-pool-queue-metrics/index.md) |  |
| [misk.security.ssl.TlsProtocols](../misk.security.ssl/-tls-protocols/index.md) |  |
| [misk.tokens.TokenGenerator](../misk.tokens/-token-generator/index.md) | Generates an secure, unguessable, alphanumeric token for use as a universally unique ID. Tokens are encoded with a [Crockford Base32 alphabet](https//www.crockford.com/wrmg/base32.html). This alphabet contains a mix of lowercase characters and digits and is resistant to decoding errors; for example `0`, `o`, and 'O' are equivalent. |
| [io.opentracing.Tracer](../misk.tracing/io.opentracing.-tracer/index.md) (extensions in package misk.tracing) |  |
| [misk.web.metadata.Type](../misk.web.metadata/-type/index.md) |  |
| [misk.client.TypedClientFactory](../misk.client/-typed-client-factory/index.md) |  |
| [misk.client.TypedHttpClientModule](../misk.client/-typed-http-client-module/index.md) | Creates a retrofit-backed typed client given an API interface and an HTTP configuration. |
| [misk.client.TypedPeerClientFactory](../misk.client/-typed-peer-client-factory/index.md) | Factory for creating typed clients that call other members of a cluster. |
| [misk.client.TypedPeerHttpClientModule](../misk.client/-typed-peer-http-client-module/index.md) | Creates a retrofit-backed typed client factory given an API interface and an HTTP configuration. |
| [misk.client.UnixDomainServerSocketFactory](../misk.client/-unix-domain-server-socket-factory/index.md) | Impersonate TCP-style ServerSocketFactory over UNIX domain sockets. |
| [misk.client.UnixDomainSocketFactory](../misk.client/-unix-domain-socket-factory/index.md) | Impersonate TCP-style SocketFactory over UNIX domain sockets. |
| [misk.web.marshal.Unmarshaller](../misk.web.marshal/-unmarshaller/index.md) | Unmarshalls a typed object from an incoming source |
| [misk.web.dashboard.ValidWebEntry](../misk.web.dashboard/-valid-web-entry/index.md) |  |
| [misk.web.metadata.WebActionMetadata](../misk.web.metadata/-web-action-metadata/index.md) |  |
| [misk.web.metadata.WebActionMetadataAction](../misk.web.metadata/-web-action-metadata-action/index.md) |  |
| [misk.web.WebActionModule](../misk.web/-web-action-module/index.md) |  |
| [misk.web.WebConfig](../misk.web/-web-config/index.md) |  |
| [misk.web.proxy.WebProxyAction](../misk.web.proxy/-web-proxy-action/index.md) | WebProxyAction |
| [misk.web.proxy.WebProxyEntry](../misk.web.proxy/-web-proxy-entry/index.md) | Maps URLs requested against this server to URLs of servers to delegate to |
| [misk.web.WebSslConfig](../misk.web/-web-ssl-config/index.md) |  |
| [misk.web.dashboard.WebTab](../misk.web.dashboard/-web-tab/index.md) |  |
| [misk.web.dashboard.WebTabResourceModule](../misk.web.dashboard/-web-tab-resource-module/index.md) | Declare how to serve the resources for a [WebTab](../misk.web.dashboard/-web-tab/index.md) (JS, HTML, CSS...) |
| [misk.web.WebUnixDomainSocketConfig](../misk.web/-web-unix-domain-socket-config/index.md) |  |
| [misk.concurrent.WrappingListeningExecutorService](../misk.concurrent/-wrapping-listening-executor-service/index.md) | [ListeningExecutorService](#) which wraps all calls |
| [misk.security.cert.X500Name](../misk.security.cert/-x500-name/index.md) |  |
| [java.security.cert.X509Certificate](../misk.security.cert/java.security.cert.-x509-certificate/index.md) (extensions in package misk.security.cert) |  |
