[misk](../../index.md) / [misk.client](../index.md) / [ClientApplicationInterceptor](./index.md)

# ClientApplicationInterceptor

`interface ClientApplicationInterceptor`

Intercepts client side calls at the application level, able to view and modify the
outgoing request arguments, and to observe the application level response

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `interface Factory`<br>This interface is used with Guice multibindings. Register instances by calling `multibind()` in a `KAbstractModule`: |

### Functions

| Name | Summary |
|---|---|
| [intercept](intercept.md) | `abstract fun intercept(chain: `[`ClientChain`](../-client-chain/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Intercepts the execution of a call. Can observe / modify the outgoing request, and can register a callback to observe the response |
| [interceptBeginCall](intercept-begin-call.md) | `abstract fun interceptBeginCall(chain: `[`BeginClientCallChain`](../-begin-client-call-chain/index.md)`): Call<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>Intercepts the start of a new call. Can view or modify the arguments to the call |
