[misk](../index.md) / [misk.client](./index.md)

## Package misk.client

### Types

| Name | Summary |
|---|---|
| [BeginClientCallChain](-begin-client-call-chain/index.md) | `interface BeginClientCallChain` |
| [ClientAction](-client-action/index.md) | `data class ClientAction`<br>Metadata about a client action |
| [ClientApplicationInterceptor](-client-application-interceptor/index.md) | `interface ClientApplicationInterceptor`<br>Intercepts client side calls at the application level, able to view and modify the outgoing request arguments, and to observe the application level response |
| [ClientChain](-client-chain/index.md) | `interface ClientChain` |
| [ClientMetricsInterceptor](-client-metrics-interceptor/index.md) | `class ClientMetricsInterceptor : `[`ClientNetworkInterceptor`](-client-network-interceptor/index.md) |
| [ClientNetworkChain](-client-network-chain/index.md) | `interface ClientNetworkChain` |
| [ClientNetworkInterceptor](-client-network-interceptor/index.md) | `interface ClientNetworkInterceptor`<br>Intercepts client side calls at the application level, able to view and modify the outgoing HTTP request and observe the returned HTTP response |
| [ClientNetworkInterceptorsModule](-client-network-interceptors-module/index.md) | `class ClientNetworkInterceptorsModule : KAbstractModule`<br>The common set of [ClientNetworkInterceptor](-client-network-interceptor/index.md)s for all misk apps. |
| [EnvoyClientEndpointProvider](-envoy-client-endpoint-provider/index.md) | `interface EnvoyClientEndpointProvider`<br>Envoy configuration provider per endpoint that misk clients can customize to their needs. |
| [GrpcClientModule](-grpc-client-module/index.md) | `class GrpcClientModule<T : Service, G : `[`T`](-grpc-client-module/index.md#T)`> : KAbstractModule`<br>Creates a gRPC client given a Wire-generated interface and HTTP configuration. |
| [HttpClientConfigUrlProvider](-http-client-config-url-provider/index.md) | `class HttpClientConfigUrlProvider`<br>Calculates the url for an http client config, which can differ depending on if the client is envoy-based or connects directly. |
| [HttpClientEndpointConfig](-http-client-endpoint-config/index.md) | `data class HttpClientEndpointConfig` |
| [HttpClientEnvoyConfig](-http-client-envoy-config/index.md) | `data class HttpClientEnvoyConfig` |
| [HttpClientFactory](-http-client-factory/index.md) | `class HttpClientFactory` |
| [HttpClientModule](-http-client-module/index.md) | `class HttpClientModule : KAbstractModule`<br>Provides an [OkHttpClient](#) and [ProtoMessageHttpClient](-proto-message-http-client/index.md) for a peer service |
| [HttpClientsConfig](-http-clients-config/index.md) | `data class HttpClientsConfig : `[`Config`](../misk.config/-config.md) |
| [HttpClientsConfigModule](-http-clients-config-module/index.md) | `class HttpClientsConfigModule : KAbstractModule` |
| [HttpClientSSLConfig](-http-client-s-s-l-config/index.md) | `data class HttpClientSSLConfig` |
| [JettyPortPeerClientModule](-jetty-port-peer-client-module/index.md) | `class JettyPortPeerClientModule : KAbstractModule`<br>For testing. |
| [PeerClientFactory](-peer-client-factory/index.md) | `class PeerClientFactory`<br>Factory that creates [OkHttpClient](#)s for connecting to another instance of the same application running in the same cluster. |
| [PeerClientModule](-peer-client-module/index.md) | `class PeerClientModule : KAbstractModule`<br>Binds a [PeerClientFactory](-peer-client-factory/index.md) that calls peers on the HTTPS port of this process's server, as determined by the SSL port in the [WebConfig](../misk.web/-web-config/index.md). |
| [ProtoMessageHttpClient](-proto-message-http-client/index.md) | `class ProtoMessageHttpClient`<br>This helper class is for making HTTP requests to an endpoint that handles protobuf Message classes. |
| [TypedClientFactory](-typed-client-factory/index.md) | `class TypedClientFactory` |
| [TypedHttpClientModule](-typed-http-client-module/index.md) | `class TypedHttpClientModule<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : KAbstractModule`<br>Creates a retrofit-backed typed client given an API interface and an HTTP configuration. |
| [TypedPeerClientFactory](-typed-peer-client-factory/index.md) | `interface TypedPeerClientFactory<T>`<br>Factory for creating typed clients that call other members of a cluster. |
| [TypedPeerHttpClientModule](-typed-peer-http-client-module/index.md) | `class TypedPeerHttpClientModule<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : KAbstractModule`<br>Creates a retrofit-backed typed client factory given an API interface and an HTTP configuration. |
| [UnixDomainServerSocketFactory](-unix-domain-server-socket-factory/index.md) | `class UnixDomainServerSocketFactory : `[`ServerSocketFactory`](https://docs.oracle.com/javase/8/docs/api/javax/net/ServerSocketFactory.html)<br>Impersonate TCP-style ServerSocketFactory over UNIX domain sockets. |
| [UnixDomainSocketFactory](-unix-domain-socket-factory/index.md) | `class UnixDomainSocketFactory : `[`SocketFactory`](https://docs.oracle.com/javase/8/docs/api/javax/net/SocketFactory.html)<br>Impersonate TCP-style SocketFactory over UNIX domain sockets. |
