[misk](../../index.md) / [misk.clustering.weights](../index.md) / [ClusterWeightProvider](./index.md)

# ClusterWeightProvider

`interface ClusterWeightProvider`

Provides the current weight assigned to the cluster.

A weight value is between 0 and 100 to indicate how much traffic a cluster should handle.
Typically an active-passive setup has 1 active cluster with 100 and 1 passive cluster with 0.

If your application does not require dynamic cluster weights, you can install the
[ActiveClusterWeightModule](../-active-cluster-weight-module/index.md)

If your application does require dynamic cluster weights, you need must provide your own impl
and [ClusterWeightService](../-cluster-weight-service.md) for others to depend on.

### Functions

| Name | Summary |
|---|---|
| [get](get.md) | `abstract fun get(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [ActiveClusterWeight](../-active-cluster-weight/index.md) | `class ActiveClusterWeight : `[`ClusterWeightProvider`](./index.md)<br>A static [ClusterWeightProvider](./index.md) that always returns 100 |
| [FakeClusterWeight](../-fake-cluster-weight/index.md) | `class FakeClusterWeight : `[`ClusterWeightProvider`](./index.md)<br>A [ClusterWeightProvider](./index.md) for testing |
