[misk](../index.md) / [misk.concurrent](./index.md)

## Package misk.concurrent

### Types

| Name | Summary |
|---|---|
| [ExecutorServiceModule](-executor-service-module/index.md) | `class ExecutorServiceModule : KAbstractModule`<br>Install this to bind an executor service with [annotation](#). The executor service will be automatically shut down when the service shuts down. |
| [ExplicitReleaseBlockingQueue](-explicit-release-blocking-queue/index.md) | `class ExplicitReleaseBlockingQueue<T> : `[`BlockingQueue`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/BlockingQueue.html)`<`[`T`](-explicit-release-blocking-queue/index.md#T)`>`<br>An [ExplicitReleaseBlockingQueue](-explicit-release-blocking-queue/index.md) is a [BlockingQueue](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/BlockingQueue.html) that only returns elements from [BlockingQueue.take](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/BlockingQueue.html#take()), [BlockingQueue.poll](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/BlockingQueue.html#poll(long, java.util.concurrent.TimeUnit)), and [BlockingQueue.peek](https://docs.oracle.com/javase/8/docs/api/java/util/Queue.html#peek()) after a call to [ExplicitReleaseBlockingQueue.release](-explicit-release-blocking-queue/release.md). Used by tests that want to explicitly control when pollers receive queued items. |
| [ExplicitReleaseDelayQueue](-explicit-release-delay-queue/index.md) | `class ExplicitReleaseDelayQueue<T : `[`Delayed`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Delayed.html)`> : `[`BlockingQueue`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/BlockingQueue.html)`<`[`T`](-explicit-release-delay-queue/index.md#T)`>`<br>An [ExplicitReleaseDelayQueue](-explicit-release-delay-queue/index.md) is an [ExplicitReleaseBlockingQueue](-explicit-release-blocking-queue/index.md) that release elements in the order in which they expire |
| [Sleeper](-sleeper/index.md) | `interface Sleeper`<br>Abstraction for Thread.sleep() that allows for testing. |
| [WrappingListeningExecutorService](-wrapping-listening-executor-service/index.md) | `abstract class WrappingListeningExecutorService : ForwardingListeningExecutorService`<br>[ListeningExecutorService](#) which wraps all calls |
