[misk](../../index.md) / [misk.config](../index.md) / [MiskConfig](./index.md)

# MiskConfig

`object MiskConfig`

### Types

| Name | Summary |
|---|---|
| [RealSecret](-real-secret/index.md) | `class RealSecret<T> : `[`Secret`](../-secret/index.md)`<`[`T`](-real-secret/index.md#T)`>` |
| [SecretJacksonModule](-secret-jackson-module/index.md) | `class SecretJacksonModule : SimpleModule` |

### Functions

| Name | Summary |
|---|---|
| [filesInDir](files-in-dir.md) | `fun filesInDir(dir: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, filter: `[`FilenameFilter`](https://docs.oracle.com/javase/8/docs/api/java/io/FilenameFilter.html)` = FilenameFilter { _, filename -> filename.endsWith(".yaml") }): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`File`](https://docs.oracle.com/javase/8/docs/api/java/io/File.html)`>` |
| [flattenYamlMap](flatten-yaml-map.md) | `fun flattenYamlMap(configYamls: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?>): JsonNode`<br>Returns a JsonNode that combines the YAMLs in `configYamls`. If two nodes define the same value the last one wins. |
| [load](load.md) | `fun <T : `[`Config`](../-config.md)`> load(appName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, environment: `[`Env`](../../misk.environment/-env/index.md)`, overrideFiles: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`File`](https://docs.oracle.com/javase/8/docs/api/java/io/File.html)`> = listOf(), resourceLoader: ResourceLoader = ResourceLoader.SYSTEM): `[`T`](load.md#T)<br>`fun <T : `[`Config`](../-config.md)`> load(configClass: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<out `[`Config`](../-config.md)`>, appName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, environment: `[`Env`](../../misk.environment/-env/index.md)`, overrideFiles: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`File`](https://docs.oracle.com/javase/8/docs/api/java/io/File.html)`> = listOf(), resourceLoader: ResourceLoader = ResourceLoader.SYSTEM): `[`T`](load.md#T) |
| [loadConfigYamlMap](load-config-yaml-map.md) | `fun loadConfigYamlMap(appName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, environment: `[`Env`](../../misk.environment/-env/index.md)`, overrideFiles: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`File`](https://docs.oracle.com/javase/8/docs/api/java/io/File.html)`>): `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?>`<br>Returns a map whose keys are the names of the source Yaml files to load, and whose values are the contents of those files. If a file is absent the map’s value will be null. |
| [toYaml](to-yaml.md) | `fun <T : `[`Config`](../-config.md)`> toYaml(config: `[`T`](to-yaml.md#T)`, resourceLoader: ResourceLoader): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
