[misk](../../index.md) / [misk.environment](../index.md) / [Deployment](./index.md)

# Deployment

`data class Deployment`

Deployment describes the context in which the application is running

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Deployment(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, isProduction: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, isTest: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, isLocalDevelopment: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false)`<br>Deployment describes the context in which the application is running |

### Properties

| Name | Summary |
|---|---|
| [isFake](is-fake.md) | `val isFake: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if running outside of a cluster (CI or local development). Mutually exclusive with isReal. |
| [isLocalDevelopment](is-local-development.md) | `val isLocalDevelopment: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Whether the service is running on a local developer machine, including as a Docker image. |
| [isProduction](is-production.md) | `val isProduction: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Whether the service is running in a production environment, having an SLA or handling customer data. |
| [isReal](is-real.md) | `val isReal: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if running in a managed cluster, such as a staging or production cluster. Mutually exclusive with isFake. |
| [isTest](is-test.md) | `val isTest: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Whether the service is running in a test environment, either locally or in a CI. |
| [name](name.md) | `val name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>The name of this deployment. This is used for debugging and should not be parsed. |
