[misk](../index.md) / [misk.environment](./index.md)

## Package misk.environment

### Types

| Name | Summary |
|---|---|
| [Deployment](-deployment/index.md) | `data class Deployment`<br>Deployment describes the context in which the application is running |
| [DeploymentModule](-deployment-module/index.md) | `class DeploymentModule : KAbstractModule`<br>Binds [Deployment](-deployment/index.md) and [Env](-env/index.md) to make them available to services and actions |
| [Env](-env/index.md) | `data class Env`<br>The raw environment name. The set of possibilities is unbounded so this should rarely be used. Instead, use the Deployment type for behavior based on characteristics of an environment. |
| [EnvironmentModule](-environment-module/index.md) | `class EnvironmentModule : KAbstractModule`<br>Binds [Environment](#) to make it available to services and actions |
| [EnvVarLoader](-env-var-loader/index.md) | `interface EnvVarLoader`<br>Loads an environment variable value. |
| [FakeEnvVarModule](-fake-env-var-module/index.md) | `class FakeEnvVarModule : KAbstractModule`<br>Binds a [EnvVarLoader](-env-var-loader/index.md) for tests. Tests can contribute values through the `@ForEnvVars Map<String, String>` binding. |
| [RealEnvVarModule](-real-env-var-module/index.md) | `class RealEnvVarModule : KAbstractModule`<br>Binds a [EnvVarLoader](-env-var-loader/index.md) for production |

### Annotations

| Name | Summary |
|---|---|
| [ForEnvVars](-for-env-vars/index.md) | `annotation class ForEnvVars` |
