[misk](../../index.md) / [misk.exceptions](../index.md) / [ActionException](./index.md)

# ActionException

`open class ActionException : `[`Exception`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)

Base class for exceptions thrown by actions, translated into responses

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ActionException(statusCode: `[`StatusCode`](../-status-code/index.md)`, message: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = statusCode.name, cause: `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`? = null)`<br>Base class for exceptions thrown by actions, translated into responses |

### Properties

| Name | Summary |
|---|---|
| [statusCode](status-code.md) | `val statusCode: `[`StatusCode`](../-status-code/index.md) |

### Inheritors

| Name | Summary |
|---|---|
| [BadRequestException](../-bad-request-exception/index.md) | `open class BadRequestException : `[`ActionException`](./index.md)<br>Base exception for bad client requests |
| [ConflictException](../-conflict-exception/index.md) | `open class ConflictException : `[`ActionException`](./index.md)<br>Base exception for when a request causes a conflict |
| [NotFoundException](../-not-found-exception/index.md) | `open class NotFoundException : `[`ActionException`](./index.md)<br>Base exception for when resources are not found |
| [ResourceUnavailableException](../-resource-unavailable-exception/index.md) | `open class ResourceUnavailableException : `[`ActionException`](./index.md)<br>Base exception for when a resource is unavailable |
| [TooManyRequestsException](../-too-many-requests-exception/index.md) | `open class TooManyRequestsException : `[`ActionException`](./index.md) |
| [UnauthenticatedException](../-unauthenticated-exception/index.md) | `open class UnauthenticatedException : `[`ActionException`](./index.md)<br>Base exception for when authentication fails |
| [UnauthorizedException](../-unauthorized-exception/index.md) | `open class UnauthorizedException : `[`ActionException`](./index.md)<br>Base exception for when authenticated credentials lack access to a resource |
