[misk](../index.md) / [misk.exceptions](./index.md)

## Package misk.exceptions

### Types

| Name | Summary |
|---|---|
| [StatusCode](-status-code/index.md) | `enum class StatusCode`<br>Common status codes for actions |

### Exceptions

| Name | Summary |
|---|---|
| [ActionException](-action-exception/index.md) | `open class ActionException : `[`Exception`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)<br>Base class for exceptions thrown by actions, translated into responses |
| [BadRequestException](-bad-request-exception/index.md) | `open class BadRequestException : `[`ActionException`](-action-exception/index.md)<br>Base exception for bad client requests |
| [ConflictException](-conflict-exception/index.md) | `open class ConflictException : `[`ActionException`](-action-exception/index.md)<br>Base exception for when a request causes a conflict |
| [NotFoundException](-not-found-exception/index.md) | `open class NotFoundException : `[`ActionException`](-action-exception/index.md)<br>Base exception for when resources are not found |
| [ResourceUnavailableException](-resource-unavailable-exception/index.md) | `open class ResourceUnavailableException : `[`ActionException`](-action-exception/index.md)<br>Base exception for when a resource is unavailable |
| [TooManyRequestsException](-too-many-requests-exception/index.md) | `open class TooManyRequestsException : `[`ActionException`](-action-exception/index.md) |
| [UnauthenticatedException](-unauthenticated-exception/index.md) | `open class UnauthenticatedException : `[`ActionException`](-action-exception/index.md)<br>Base exception for when authentication fails |
| [UnauthorizedException](-unauthorized-exception/index.md) | `open class UnauthorizedException : `[`ActionException`](-action-exception/index.md)<br>Base exception for when authenticated credentials lack access to a resource |

### Functions

| Name | Summary |
|---|---|
| [requireRequest](require-request.md) | `fun requireRequest(check: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`, lazyMessage: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Similar to [kotlin.require](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/require.html), but throws [BadRequestException](-bad-request-exception/index.md) if the check fails |
