[misk](../../index.md) / [misk.flags.memory](../index.md) / [InMemoryFlagStore](./index.md)

# InMemoryFlagStore

`@Singleton class InMemoryFlagStore : `[`FlagStore`](../../misk.flags/-flag-store/index.md)

In memory implementation of a [FlagStore](../../misk.flags/-flag-store/index.md), suitable for use in testing

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `InMemoryFlagStore()`<br>In memory implementation of a [FlagStore](../../misk.flags/-flag-store/index.md), suitable for use in testing |

### Properties

| Name | Summary |
|---|---|
| [booleanFlags](boolean-flags.md) | `val booleanFlags: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`InMemoryBooleanFlag`](../-in-memory-boolean-flag/index.md)`>` |
| [doubleFlags](double-flags.md) | `val doubleFlags: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`InMemoryDoubleFlag`](../-in-memory-double-flag/index.md)`>` |
| [flags](flags.md) | `val flags: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`InMemoryFlag`](../-in-memory-flag/index.md)`<*>>` |
| [intFlags](int-flags.md) | `val intFlags: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`InMemoryIntFlag`](../-in-memory-int-flag/index.md)`>` |
| [stringFlags](string-flags.md) | `val stringFlags: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`InMemoryStringFlag`](../-in-memory-string-flag/index.md)`>` |

### Functions

| Name | Summary |
|---|---|
| [awaitRegistrationsComplete](await-registrations-complete.md) | `fun awaitRegistrationsComplete(timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Blocks until all pending registrations have completed |
| [registerFlag](register-flag.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> registerFlag(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, description: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](register-flag.md#T)`>): `[`InMemoryFlag`](../-in-memory-flag/index.md)`<`[`T`](register-flag.md#T)`>`<br>Asynchronously registers interest in the given flag of the provided type |

### Extension Functions

| Name | Summary |
|---|---|
| [registerFlag](../../misk.flags/register-flag.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`FlagStore`](../../misk.flags/-flag-store/index.md)`.registerFlag(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, description: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Flag`](../../misk.flags/-flag/index.md)`<`[`T`](../../misk.flags/register-flag.md#T)`>` |
