[misk](../../index.md) / [misk.flags](../index.md) / [FlagStore](./index.md)

# FlagStore

`interface FlagStore`

Applications register their interest in monitoring flags through the [registerFlag](register-flag.md)
calls. If registration and watching requires contacting a remote service (e.g. a flag service,
Zookeeper, etc), this should be done asynchronously so that multiple flags can be registered
in parallel, with the [Flag.get](../-flag/get.md) calls blocking until the registration for that flag is
complete. An application can also call [awaitRegistrationsComplete](await-registrations-complete.md) to block until all
pending registrations have completed, allowing e.g. the application to avoid processing
incoming requests until all of its flags are available and watched

### Functions

| Name | Summary |
|---|---|
| [awaitRegistrationsComplete](await-registrations-complete.md) | `abstract fun awaitRegistrationsComplete(timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Blocks until all pending registrations have completed |
| [registerFlag](register-flag.md) | `abstract fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> registerFlag(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, description: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](register-flag.md#T)`>): `[`Flag`](../-flag/index.md)`<`[`T`](register-flag.md#T)`>`<br>Asynchronously registers interest in the given flag of the provided type |

### Extension Functions

| Name | Summary |
|---|---|
| [registerFlag](../register-flag.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`FlagStore`](./index.md)`.registerFlag(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, description: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Flag`](../-flag/index.md)`<`[`T`](../register-flag.md#T)`>` |

### Inheritors

| Name | Summary |
|---|---|
| [InMemoryFlagStore](../../misk.flags.memory/-in-memory-flag-store/index.md) | `class InMemoryFlagStore : `[`FlagStore`](./index.md)<br>In memory implementation of a [FlagStore](./index.md), suitable for use in testing |
