[misk](../index.md) / [misk.flags](./index.md)

## Package misk.flags

### Types

| Name | Summary |
|---|---|
| [Flag](-flag/index.md) | `interface Flag<out T>` |
| [Flags](-flags/index.md) | `open class Flags` |
| [FlagsModule](-flags-module/index.md) | `abstract class FlagsModule : KAbstractModule`<br>Installs support for flag. Applications should inherit from this module and override [configureFlags](-flags-module/configure-flags.md), calling the various bindXXXFlags methods to make flag variables available |
| [FlagStore](-flag-store/index.md) | `interface FlagStore`<br>Applications register their interest in monitoring flags through the [registerFlag](-flag-store/register-flag.md) calls. If registration and watching requires contacting a remote service (e.g. a flag service, Zookeeper, etc), this should be done asynchronously so that multiple flags can be registered in parallel, with the [Flag.get](-flag/get.md) calls blocking until the registration for that flag is complete. An application can also call [awaitRegistrationsComplete](-flag-store/await-registrations-complete.md) to block until all pending registrations have completed, allowing e.g. the application to avoid processing incoming requests until all of its flags are available and watched |
| [JsonFlag](-json-flag/index.md) | `class JsonFlag<out T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`Flag`](-flag/index.md)`<`[`T`](-json-flag/index.md#T)`>` |

### Functions

| Name | Summary |
|---|---|
| [registerFlag](register-flag.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`FlagStore`](-flag-store/index.md)`.registerFlag(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, description: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Flag`](-flag/index.md)`<`[`T`](register-flag.md#T)`>` |
