[misk](../../index.md) / [misk.resources](../index.md) / [ResourceLoader](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`ResourceLoader(backends: `[`Map`](http://docs.oracle.com/javase/8/docs/api/java/util/Map.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`Backend`](-backend/index.md)`>)`

ResourceLoader is a testable API for loading resources from the classpath, from the filesystem,
from memory, or from another [Backend](-backend/index.md) source.

Resource addresses have a scheme name, a colon, and an absolute filesystem-like path:
`classpath:/migrations/v1.sql`. Schemes identify backends `classpath:` or `memory:`. Paths start
with a slash and have any number of segments.

**Classpath resources** use the scheme `classpath:`. The backend reads data from the
`src/main/resources` of the project's modules and the contents of all library `.jar` files.
Classpath resources are read-only.

**Filesystem resources** use the scheme `filesystem:`. The backend reads data from the host
machine's local filesystem. It is read-only and does not support [list](list.md).

**Memory resources** use the scheme `memory:`. The backend starts empty and is populated by calls
to [put](put.md).

Other backends are permitted. They should be registered with a `MapBinder` with the backend
scheme like `classpath:` as the key.

