[misk](../../index.md) / [misk.scope](../index.md) / [ActionScope](./index.md)

# ActionScope

`@Singleton class ActionScope : `[`AutoCloseable`](https://docs.oracle.com/javase/8/docs/api/java/lang/AutoCloseable.html)

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [enter](enter.md) | `fun enter(seedData: `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<Key<*>, `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>): `[`ActionScope`](./index.md)<br>Starts the scope on a thread with the provided seed data |
| [get](get.md) | `fun <T> get(key: Key<`[`T`](get.md#T)`>): `[`T`](get.md#T)<br>Returns the action scoped value for the given key |
| [inScope](in-scope.md) | `fun inScope(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if currently in the scope |
| [propagate](propagate.md) | `fun <T> propagate(c: `[`Callable`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Callable.html)`<`[`T`](propagate.md#T)`>): `[`Callable`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Callable.html)`<`[`T`](propagate.md#T)`>`<br>Wraps a [Callable](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Callable.html) that will be called on another thread, propagating the current scoped data onto that thread`fun <T> propagate(f: `[`KFunction`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-function/index.html)`<`[`T`](propagate.md#T)`>): `[`KFunction`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-function/index.html)`<`[`T`](propagate.md#T)`>`<br>Wraps a [KFunction](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-function/index.html) that will be called on another thread, propagating the current scoped data onto that thread`fun <T> propagate(f: () -> `[`T`](propagate.md#T)`): () -> `[`T`](propagate.md#T)<br>Wraps a function or lambda that will be called on another thread, propagating the current scoped data onto that thread |
