[misk](../../index.md) / [misk.scope](../index.md) / [ActionScopedProviderModule](./index.md)

# ActionScopedProviderModule

`abstract class ActionScopedProviderModule : KAbstractModule`

Module used by components and applications to provide [ActionScoped](#) context objects

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ActionScopedProviderModule()`<br>Module used by components and applications to provide [ActionScoped](#) context objects |

### Functions

| Name | Summary |
|---|---|
| [bindProvider](bind-provider.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> bindProvider(kclass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](bind-provider.md#T)`>, providerType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`ActionScopedProvider`](../-action-scoped-provider/index.md)`<`[`T`](bind-provider.md#T)`>>, annotatedBy: `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`? = null): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`fun <T> bindProvider(type: TypeLiteral<`[`T`](bind-provider.md#T)`>, providerType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`ActionScopedProvider`](../-action-scoped-provider/index.md)`<`[`T`](bind-provider.md#T)`>>, annotatedBy: `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`? = null): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, A : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> bindProvider(kclass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](bind-provider.md#T)`>, providerType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`ActionScopedProvider`](../-action-scoped-provider/index.md)`<`[`T`](bind-provider.md#T)`>>, annotatedBy: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`A`](bind-provider.md#A)`>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`fun <T, A : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> bindProvider(type: TypeLiteral<`[`T`](bind-provider.md#T)`>, providerType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`ActionScopedProvider`](../-action-scoped-provider/index.md)`<`[`T`](bind-provider.md#T)`>>, annotatedBy: `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`A`](bind-provider.md#A)`>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Binds an annotation qualified [ActionScoped](#) along with its provider |
| [bindSeedData](bind-seed-data.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> bindSeedData(kclass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](bind-seed-data.md#T)`>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Binds an [ActionScoped](#) which only pulls from data seeded at the scope entry`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> bindSeedData(kclass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](bind-seed-data.md#T)`>, a: `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, A : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> bindSeedData(kclass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](bind-seed-data.md#T)`>, a: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`A`](bind-seed-data.md#A)`>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Binds an annotation qualified [ActionScoped](#) which only pulls from data seeded at the scope entry |
| [configure](configure.md) | `open fun configure(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [configureProviders](configure-providers.md) | `abstract fun configureProviders(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [AccessControlModule](../../misk.security.authz/-access-control-module/index.md) | `class AccessControlModule : `[`ActionScopedProviderModule`](./index.md)<br>Install support for performing access control checks for actions based on the incoming caller. |
