[misk](../../index.md) / [misk.security.authz](../index.md) / [AccessAnnotationEntry](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`AccessAnnotationEntry(annotation: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>, services: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = listOf(), capabilities: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = listOf())`

Use this to alias an annotation to a set of services and capabilities. This can be used to decouple code
that needs access control from the policy that defines it.

To demonstrate, let's define an access annotation. By convention these annotations are suffixed
`Access`:

```
@Retention(AnnotationRetention.RUNTIME)
@Target(AnnotationTarget.FUNCTION)
annotation class PaleontologistAccess
```

Next we define actions that apply our annotation:

```
class DiscoverDinosaurAction @Inject constructor() : WebAction {
  @Get("/discover")
  @PaleontologistAccess
  fun discover()
}

class DigUpDinosaurAction @Inject constructor() : WebAction {
  @Get("/dig")
  @PaleontologistAccess
  fun dig()
}
```

Finally we use multibindings to specify which services and capabilities are permitted:

```
multibind<AccessAnnotationEntry>().toInstance(
 AccessAnnotationEntry<PaleontologistAccess>(capabilities = listOf("paleontologist", "intern")))
```

