[misk](../../index.md) / [misk.security.authz](../index.md) / [MiskCallerAuthenticator](./index.md)

# MiskCallerAuthenticator

`interface MiskCallerAuthenticator`

Interface for determining the current [MiskCaller](#). Typically use an [ActionScoped](#),
[ActionScoped](#), etc to determine the caller based on request headers or
client certificate information.

This interface is used with Guice multibindings. Register instances by calling `multibind()`
in a `KAbstractModule`:

```
multibind<MiskCallerAuthenticator>().to<MyAuthenticator>()
```

We allow binding up many authenticators in case applications would like to support
alternative ways in which to authenticate requests. For example, one mechanism
might leverage HTTP headers while another mechanism might leverage third party
authentication services.

### Functions

| Name | Summary |
|---|---|
| [getAuthenticatedCaller](get-authenticated-caller.md) | `abstract fun getAuthenticatedCaller(): MiskCaller?` |

### Inheritors

| Name | Summary |
|---|---|
| [FakeCallerAuthenticator](../-fake-caller-authenticator/index.md) | `class FakeCallerAuthenticator : `[`MiskCallerAuthenticator`](./index.md)<br>A caller authenticator that blindly trusts HTTP headers. Unsafe for production use. |
