[misk](../index.md) / [misk.security.authz](./index.md)

## Package misk.security.authz

### Types

| Name | Summary |
|---|---|
| [AccessAnnotationEntry](-access-annotation-entry/index.md) | `data class AccessAnnotationEntry`<br>Use this to alias an annotation to a set of services and capabilities. This can be used to decouple code that needs access control from the policy that defines it. |
| [AccessControlModule](-access-control-module/index.md) | `class AccessControlModule : `[`ActionScopedProviderModule`](../misk.scope/-action-scoped-provider-module/index.md)<br>Install support for performing access control checks for actions based on the incoming caller. |
| [AccessInterceptor](-access-interceptor/index.md) | `class AccessInterceptor : `[`ApplicationInterceptor`](../misk/-application-interceptor/index.md) |
| [FakeCallerAuthenticator](-fake-caller-authenticator/index.md) | `class FakeCallerAuthenticator : `[`MiskCallerAuthenticator`](-misk-caller-authenticator/index.md)<br>A caller authenticator that blindly trusts HTTP headers. Unsafe for production use. |
| [MiskCallerAuthenticator](-misk-caller-authenticator/index.md) | `interface MiskCallerAuthenticator`<br>Interface for determining the current [MiskCaller](#). Typically use an [ActionScoped](#), [ActionScoped](#), etc to determine the caller based on request headers or client certificate information. |

### Annotations

| Name | Summary |
|---|---|
| [DevelopmentOnly](-development-only/index.md) | `annotation class DevelopmentOnly` |

### Functions

| Name | Summary |
|---|---|
| [AccessAnnotationEntry](-access-annotation-entry.md) | `fun <T : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> AccessAnnotationEntry(services: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = listOf(), capabilities: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = listOf()): `[`AccessAnnotationEntry`](-access-annotation-entry/index.md) |
