[misk](../../index.md) / [misk.tasks](../index.md) / [RepeatedTaskQueue](./index.md)

# RepeatedTaskQueue

`class RepeatedTaskQueue : AbstractExecutionThreadService`

A [RepeatedTaskQueue](./index.md) runs repeated tasks at a user controlled rate. Internally it uses
a [DelayQueue](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/DelayQueue.html) to hold the pending tasks; a background thread pulls the next task
from the [DelayQueue](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/DelayQueue.html) and hands it off to an executor service for execution.

[RepeatedTaskQueue](./index.md) implements the [Service](#) interface, which requires proper startup and shutdown.
Alternatively, you can add new instances to the [Service](#) multibind.

### Functions

| Name | Summary |
|---|---|
| [executor](executor.md) | `fun executor(): `[`Executor`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executor.html) |
| [run](run.md) | `fun run(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>runs the main event loop, pulling the next task from the queue and handing it off to the executor for dispatching |
| [schedule](schedule.md) | `fun schedule(delay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, retryDelayOnFailure: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`? = null, task: () -> `[`Result`](../-result/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Schedules a task to run repeatedly after an initial delay. The task itself determines the next execution time. Provide an optional retryDelayOnFailure parameter to determine when the job should be retried in the case of an unhandled exception by the client |
| [scheduleWithBackoff](schedule-with-backoff.md) | `fun scheduleWithBackoff(timeBetweenRuns: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, initialDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)` = timeBetweenRuns, noWorkBackoff: Backoff = config.defaultBackoff(timeBetweenRuns), failureBackoff: Backoff = config.defaultBackoff(timeBetweenRuns), task: () -> `[`Status`](../-status/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Schedules a task to run repeatedly at a fixed delay, with back-off for errors and lack of available work |
| [serviceName](service-name.md) | `fun serviceName(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [startUp](start-up.md) | `fun startUp(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [triggerShutdown](trigger-shutdown.md) | `fun triggerShutdown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
