[misk](../../index.md) / [misk.tokens](../index.md) / [TokenGenerator](./index.md)

# TokenGenerator

`interface TokenGenerator`

Generates an secure, unguessable, alphanumeric token for use as a universally unique ID. Tokens
are encoded with a [Crockford Base32 alphabet](https//www.crockford.com/wrmg/base32.html). This
alphabet contains a mix of lowercase characters and digits and is resistant to decoding errors;
for example `0`, `o`, and 'O' are equivalent.

For strength similar to a [random UUID](https://docs.oracle.com/javase/8/docs/api/java/util/UUID.html#randomUUID()) (122 bits of entropy), most
callers should use the default length of 25 characters (125 bits). Using fewer characters risks
collision, which may be acceptable for some use-cases. There is no practical benefit to using
more than 25 characters.

In production, staging, and development environments tokens are always created using
[SecureRandom](https://docs.oracle.com/javase/8/docs/api/java/security/SecureRandom.html). These are some sample production tokens:

```
75dsma7kscyvbgz7ea1yy3qe8
3zg6svk9hcpvqyhej41tdkaa0
gv7s8nkevt9d7aw2eb06g640e
a17f7h6t853kzdqpc29qa8mnw
```

In tests tokens are sequential and predictable. They are prefixed with an optional label that
appears in the returned string and can be used as a namespace. It is okay to hardcode expected
tokens in test cases! These are some sample testing tokens:

```
cst0mer000000000000000035
payment000000000000000034
cst0mer000000000000000036
payment000000000000000035
```

### Functions

| Name | Summary |
|---|---|
| [generate](generate.md) | `abstract fun generate(label: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, length: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 25): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [canonicalize](canonicalize.md) | `fun canonicalize(token: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a token semantically equal to `token` but using only characters from the Crockford Base32 alphabet. This maps visually similar characters like `o` to the corresponding encoding character like `0`. Spaces are omitted. |

### Inheritors

| Name | Summary |
|---|---|
| [FakeTokenGenerator](../-fake-token-generator/index.md) | `class FakeTokenGenerator : `[`TokenGenerator`](./index.md) |
