[misk](../../index.md) / [misk.web.actions](../index.md) / [WebSocket](./index.md)

# WebSocket

`interface WebSocket`

A non-blocking interface to a web socket.

Web Socket Lifecycle

Upon normal operation each web socket progresses through a sequence of states:

Web sockets may fail due to HTTP upgrade problems, connectivity problems, or if either peer
chooses to short-circuit the graceful shutdown process:

Note that the state progression is independent for each peer. Arriving at a gracefully-closed
state indicates that a peer has sent all of its outgoing messages and received all of its
incoming messages. But it does not guarantee that the other peer will successfully receive all of
its incoming messages.

### Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | `abstract fun cancel(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Immediately and violently release resources held by this web socket, discarding any enqueued messages. This does nothing if the web socket has already been closed or canceled. |
| [close](close.md) | `abstract fun close(code: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, reason: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Attempts to initiate a graceful shutdown of this web socket. Any already-enqueued messages will be transmitted before the close message is sent but subsequent calls to {@link #send} will return false and their messages will not be enqueued. |
| [queueSize](queue-size.md) | `abstract fun queueSize(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the size in bytes of all messages enqueued to be transmitted to the server. This doesn't include framing overhead. It also doesn't include any bytes buffered by the operating system or network intermediaries. This method returns 0 if no messages are waiting in the queue. If may return a nonzero value after the web socket has been canceled; this indicates that enqueued messages were not transmitted. |
| [send](send.md) | `abstract fun send(bytes: ByteString): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Attempts to enqueue {@code text} to be UTF-8 encoded and sent as a the data of a text (type {@code 0x1}) message.`abstract fun send(text: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Attempts to enqueue {@code bytes} to be sent as a the data of a binary (type {@code 0x2}) message. |

### Inheritors

| Name | Summary |
|---|---|
| [FakeWebSocket](../-fake-web-socket/index.md) | `class FakeWebSocket : `[`WebSocket`](./index.md) |
