[misk](../../index.md) / [misk.web.dashboard](../index.md) / [WebTabResourceModule](./index.md)

# WebTabResourceModule

`class WebTabResourceModule : KAbstractModule`

Declare how to serve the resources for a [WebTab](../-web-tab/index.md) (JS, HTML, CSS...)

In Development environment, requests are proxied through to a local running build server.
In all other environments, resource requests are served from the classpath.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `WebTabResourceModule(deployment: `[`Deployment`](../../misk.environment/-deployment/index.md)`, slug: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, web_proxy_url: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, url_path_prefix: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "/_tab/$slug/", resourcePath: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "classpath:/web/_tab/$slug/")``WebTabResourceModule(isDevelopment: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`, slug: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, web_proxy_url: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, url_path_prefix: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "/_tab/$slug/", resourcePath: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "classpath:/web/_tab/$slug/")`<br>Declare how to serve the resources for a [WebTab](../-web-tab/index.md) (JS, HTML, CSS...) |

### Properties

| Name | Summary |
|---|---|
| [resourcePath](resource-path.md) | `val resourcePath: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>JVM path for non-Development environment static resources (includes `classpath:/` prefix) |
| [slug](slug.md) | `val slug: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>A unique slug to identify the tab namespace, it must match the tab's corresponding [DashboardTab](../-dashboard-tab/index.md) multibinding |
| [url_path_prefix](url_path_prefix.md) | `val url_path_prefix: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>URL namespace used to determine where to route requests with that url prefix     By Misk-Web convention, the prefix for tabs is `/_tab/{slug}/` to prevent namespace collisions with     dashboard urls such as `/_admin/` or `/app/` since path routing is by url prefix. |
| [web_proxy_url](web_proxy_url.md) | `val web_proxy_url: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>a fully qualified url for the development build server (includes `http://` prefix) |

### Functions

| Name | Summary |
|---|---|
| [configure](configure.md) | `fun configure(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
