[misk](../index.md) / [misk.web.dashboard](./index.md)

## Package misk.web.dashboard

### Types

| Name | Summary |
|---|---|
| [AdminDashboardModule](-admin-dashboard-module/index.md) | `class AdminDashboardModule : KAbstractModule`<br>Installs default Admin Dashboard that runs at multibound DashboardHomeUrl |
| [AdminDashboardTestingModule](-admin-dashboard-testing-module/index.md) | `class AdminDashboardTestingModule : KAbstractModule` |
| [DashboardHomeUrl](-dashboard-home-url/index.md) | `data class DashboardHomeUrl : `[`ValidWebEntry`](-valid-web-entry/index.md)<br>Url to link to for the home button in the dashboard navbar 1 [DashboardHomeUrl](-dashboard-home-url/index.md) should be bound per dashboard |
| [DashboardModule](-dashboard-module/index.md) | `class DashboardModule : KAbstractModule`<br>Support Misk-Web Dashboards including the Misk [AdminDashboard](-admin-dashboard/index.md) and service specific front end apps |
| [DashboardNavbarItem](-dashboard-navbar-item/index.md) | `data class DashboardNavbarItem : `[`ValidWebEntry`](-valid-web-entry/index.md)<br>A list of elements to add to the dashboard navbar Misk-Web's default navbar handles responsive layout of these items so overflow navbar items are included in the drop down menu |
| [DashboardNavbarStatus](-dashboard-navbar-status/index.md) | `data class DashboardNavbarStatus : `[`ValidWebEntry`](-valid-web-entry/index.md)<br>Banner text to show below the dashboard navbar 0 or 1 [DashboardNavbarStatus](-dashboard-navbar-status/index.md) should be bound per dashboard |
| [DashboardTab](-dashboard-tab/index.md) | `class DashboardTab : `[`WebTab`](-web-tab/index.md)<br>A [WebTab](-web-tab/index.md) with additional fields to bind to a specific Dashboard that has a tabs menu |
| [DashboardTabProvider](-dashboard-tab-provider/index.md) | `class DashboardTabProvider : Provider<`[`DashboardTab`](-dashboard-tab/index.md)`>`<br>Sets the tab's authentication capabilities/services by the multibound [AccessAnnotationEntry](../misk.security.authz/-access-annotation-entry/index.md) |
| [ValidWebEntry](-valid-web-entry/index.md) | `abstract class ValidWebEntry` |
| [WebTab](-web-tab/index.md) | `abstract class WebTab : `[`ValidWebEntry`](-valid-web-entry/index.md) |
| [WebTabResourceModule](-web-tab-resource-module/index.md) | `class WebTabResourceModule : KAbstractModule`<br>Declare how to serve the resources for a [WebTab](-web-tab/index.md) (JS, HTML, CSS...) |

### Annotations

| Name | Summary |
|---|---|
| [AdminDashboard](-admin-dashboard/index.md) | `annotation class AdminDashboard`<br>Dashboard Annotation used for all tabs bound in the Misk Admin Dashboard |
| [AdminDashboardAccess](-admin-dashboard-access/index.md) | `annotation class AdminDashboardAccess` |

### Functions

| Name | Summary |
|---|---|
| [DashboardHomeUrl](-dashboard-home-url.md) | `fun <DA : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> DashboardHomeUrl(urlPathPrefix: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`DashboardHomeUrl`](-dashboard-home-url/index.md) |
| [DashboardNavbarItem](-dashboard-navbar-item.md) | `fun <DA : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> DashboardNavbarItem(item: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, order: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`DashboardNavbarItem`](-dashboard-navbar-item/index.md) |
| [DashboardNavbarStatus](-dashboard-navbar-status.md) | `fun <DA : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> DashboardNavbarStatus(status: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`DashboardNavbarStatus`](-dashboard-navbar-status/index.md) |
| [DashboardTabProvider](-dashboard-tab-provider.md) | `fun <DA : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> DashboardTabProvider(slug: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, url_path_prefix: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, category: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "Admin", capabilities: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = setOf(), services: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`> = setOf()): `[`DashboardTabProvider`](-dashboard-tab-provider/index.md)<br>Binds a DashboardTab for Dashboard [DA](-dashboard-tab-provider.md#DA) with optional access capabilities and services`fun <DA : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`, AA : `[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`> DashboardTabProvider(slug: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, url_path_prefix: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, category: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "Admin"): `[`DashboardTabProvider`](-dashboard-tab-provider/index.md)<br>Binds a DashboardTab for Dashboard [DA](-dashboard-tab-provider.md#DA) with access annotation [AA](-dashboard-tab-provider.md#AA) |
