[misk](../../index.md) / [misk.web.exceptions](../index.md) / [ExceptionHandlingInterceptor](./index.md)

# ExceptionHandlingInterceptor

`class ExceptionHandlingInterceptor : `[`NetworkInterceptor`](../../misk.web/-network-interceptor/index.md)

Converts and logs application and component level dispatch exceptions into the appropriate
response format. Allows application and component code to control how exceptions are
represented to clients; for example by setting the status code appropriately, or by returning
a specialized response format specific to the error. Components can control how exceptions are
mapped by installing [ExceptionMapper](../-exception-mapper/index.md) via the [ExceptionMapperModule](../-exception-mapper-module/index.md)

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `class Factory : `[`NetworkInterceptor.Factory`](../../misk.web/-network-interceptor/-factory/index.md) |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ExceptionHandlingInterceptor(actionName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, mapperResolver: `[`ExceptionMapperResolver`](../-exception-mapper-resolver/index.md)`)`<br>Converts and logs application and component level dispatch exceptions into the appropriate response format. Allows application and component code to control how exceptions are represented to clients; for example by setting the status code appropriately, or by returning a specialized response format specific to the error. Components can control how exceptions are mapped by installing [ExceptionMapper](../-exception-mapper/index.md) via the [ExceptionMapperModule](../-exception-mapper-module/index.md) |

### Functions

| Name | Summary |
|---|---|
| [intercept](intercept.md) | `fun intercept(chain: `[`NetworkChain`](../../misk.web/-network-chain/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
