[misk](../../index.md) / [misk.web.exceptions](../index.md) / [ExceptionMapperModule](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`ExceptionMapperModule(exceptionClass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](index.md#T)`>, mapperClass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`M`](index.md#M)`>)`

Binds a [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) to an [ExceptionMapper](../-exception-mapper/index.md).

When an Exception occurs dispatching an Action, the bound ExceptionMapper is called to handle
the Exception. If there is not an explicit binding for the thrown Exception, the mapper for the
closest superclass is used.

Given the example code

```
install(ExceptionMapperModule.create<ActionException, ActionExceptionMapper>())
install(ExceptionMapperModule.create<MyActionException, MyActionExceptionMapper>())

class MyActionException : ActionException {}
class MyOtherActionException : ActionException {}
```

MyActionException maps to the specific MyActionExceptionMapper and MyOtherActionException
maps to the ActionExceptionMapper since uses the binding of the closest bound superclass.

