[misk](../../index.md) / [misk.web.exceptions](../index.md) / [ExceptionMapperModule](./index.md)

# ExceptionMapperModule

`class ExceptionMapperModule<M : `[`ExceptionMapper`](../-exception-mapper/index.md)`<`[`T`](index.md#T)`>, in T : `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`> : KAbstractModule`

Binds a [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) to an [ExceptionMapper](../-exception-mapper/index.md).

When an Exception occurs dispatching an Action, the bound ExceptionMapper is called to handle
the Exception. If there is not an explicit binding for the thrown Exception, the mapper for the
closest superclass is used.

Given the example code

```
install(ExceptionMapperModule.create<ActionException, ActionExceptionMapper>())
install(ExceptionMapperModule.create<MyActionException, MyActionExceptionMapper>())

class MyActionException : ActionException {}
class MyOtherActionException : ActionException {}
```

MyActionException maps to the specific MyActionExceptionMapper and MyOtherActionException
maps to the ActionExceptionMapper since uses the binding of the closest bound superclass.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ExceptionMapperModule(exceptionClass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](index.md#T)`>, mapperClass: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`M`](index.md#M)`>)`<br>Binds a [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) to an [ExceptionMapper](../-exception-mapper/index.md). |

### Functions

| Name | Summary |
|---|---|
| [configure](configure.md) | `fun configure(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [create](create.md) | `fun <T : `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`, M : `[`ExceptionMapper`](../-exception-mapper/index.md)`<`[`T`](create.md#T)`>> create(): `[`ExceptionMapperModule`](./index.md)`<`[`M`](create.md#M)`, `[`T`](create.md#T)`>` |
