[misk](../../index.md) / [misk.web.interceptors](../index.md) / [RebalancingInterceptor](./index.md)

# RebalancingInterceptor

`class RebalancingInterceptor : `[`NetworkInterceptor`](../../misk.web/-network-interceptor/index.md)

When we're deploying and redeploying our pods, we want to make sure that clients rebalance onto
the new pods. This randomly closes connections so they will be recreated, naturally balancing
connections across pods.

This does not close Unix domain socket connections. This interceptor is intended to mitigate
imbalanced load from long-lived client connections maintained from client apps.
Connections over UDS are oriented towards service mesh sidecars that employ sufficient
client-side load balancing.

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `class Factory : `[`NetworkInterceptor.Factory`](../../misk.web/-network-interceptor/-factory/index.md) |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `RebalancingInterceptor(random: ThreadLocalRandom, probability: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`)`<br>When we're deploying and redeploying our pods, we want to make sure that clients rebalance onto the new pods. This randomly closes connections so they will be recreated, naturally balancing connections across pods. |

### Functions

| Name | Summary |
|---|---|
| [intercept](intercept.md) | `fun intercept(chain: `[`NetworkChain`](../../misk.web/-network-chain/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
