[misk](../../index.md) / [misk.web.marshal](../index.md) / [Marshaller](./index.md)

# Marshaller

`interface Marshaller<in T>`

Marshalls typed kotlin objects into a [ResponseBody](#)

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `interface Factory`<br>This interface is used with Guice multibindings. Register instances by calling `multibind()` in a `KAbstractModule`: |

### Functions

| Name | Summary |
|---|---|
| [contentType](content-type.md) | `abstract fun contentType(): MediaType?` |
| [responseBody](response-body.md) | `abstract fun responseBody(o: `[`T`](index.md#T)`): ResponseBody` |

### Companion Object Functions

| Name | Summary |
|---|---|
| [actualResponseType](actual-response-type.md) | `fun actualResponseType(type: `[`KType`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-type/index.html)`): `[`Type`](https://docs.oracle.com/javase/8/docs/api/java/lang/reflect/Type.html) |

### Inheritors

| Name | Summary |
|---|---|
| [FromByteString](../-generic-marshallers/-from-byte-string/index.md) | `class FromByteString : `[`Marshaller`](./index.md)`<ByteString>` |
| [JsonMarshaller](../-json-marshaller/index.md) | `class JsonMarshaller<T> : `[`Marshaller`](./index.md)`<`[`T`](../-json-marshaller/index.md#T)`>` |
| [PlainTextMarshaller](../-plain-text-marshaller/index.md) | `object PlainTextMarshaller : `[`Marshaller`](./index.md)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [ProtobufMarshaller](../-protobuf-marshaller/index.md) | `class ProtobufMarshaller<T> : `[`Marshaller`](./index.md)`<`[`T`](../-protobuf-marshaller/index.md#T)`>` |
| [ToNothing](../-generic-marshallers/-to-nothing/index.md) | `class ToNothing : `[`Marshaller`](./index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>` |
