[misk](../../index.md) / [misk.web.marshal](../index.md) / [Unmarshaller](./index.md)

# Unmarshaller

`interface Unmarshaller`

Unmarshalls a typed object from an incoming source

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `interface Factory`<br>This interface is used with Guice multibindings. Register instances by calling `multibind()` in a `KAbstractModule`: |

### Functions

| Name | Summary |
|---|---|
| [unmarshal](unmarshal.md) | `abstract fun unmarshal(source: BufferedSource): `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |

### Inheritors

| Name | Summary |
|---|---|
| [JsonUnmarshaller](../-json-unmarshaller/index.md) | `class JsonUnmarshaller : `[`Unmarshaller`](./index.md) |
| [ProtobufUnmarshaller](../-protobuf-unmarshaller/index.md) | `class ProtobufUnmarshaller : `[`Unmarshaller`](./index.md) |
| [ToByteString](../-plain-text-unmarshaller/-to-byte-string/index.md) | `object ToByteString : `[`Unmarshaller`](./index.md) |
| [ToString](../-plain-text-unmarshaller/-to-string/index.md) | `object ToString : `[`Unmarshaller`](./index.md) |
