[misk](../../index.md) / [misk.web.metadata](../index.md) / [DashboardMetadataAction](./index.md)

# DashboardMetadataAction

`@Singleton class DashboardMetadataAction : WebAction`

Serve metadata related to a Misk-Web Dashboard

Multiple dashboards with Misk-Web tabs can be bound by binding tabs to a different
Dashboard Annotation. For example, all tabs used in the Misk Admin Dashboard are
bound with the [AdminDashboard](#) annotation; tabs used in a service front
end app, like Backfila, would be bound with a "BackfilaApp" annotation.

Dashboard related metadata is multibound with the slug that corresponds to
a Dashboard Annotation. [DashboardMetadataAction](./index.md) returns only the metadata for
the requested dashboard.

### Types

| Name | Summary |
|---|---|
| [DashboardMetadata](-dashboard-metadata/index.md) | `data class DashboardMetadata` |
| [Response](-response/index.md) | `data class Response` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `DashboardMetadataAction()`<br>Serve metadata related to a Misk-Web Dashboard |

### Properties

| Name | Summary |
|---|---|
| [callerProvider](caller-provider.md) | `lateinit var callerProvider: ActionScoped<MiskCaller?>` |

### Functions

| Name | Summary |
|---|---|
| [getAll](get-all.md) | `fun getAll(dashboard_slug: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`DashboardMetadataAction.Response`](-response/index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [asChain](../../misk.web.actions/as-chain.md) | `fun WebAction.asChain(function: `[`KFunction`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-function/index.html)`<*>, args: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>, interceptors: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`ApplicationInterceptor`](../../misk/-application-interceptor/index.md)`>): `[`Chain`](../../misk/-chain/index.md) |
