[misk](../../index.md) / [misk.web.proxy](../index.md) / [WebProxyAction](./index.md)

# WebProxyAction

`@Singleton class WebProxyAction : WebAction`

WebProxyAction

Guidelines

* Overlapping entry prefixes will resolve to the longest match
    Example
    Entries: `/_admin/config/`, `/_admin/config/subtab/`
    Request: `/_admin/config/subtab/app.js` will resolve to the `/_admin/config/subtab/` entry
* url_path_prefix starts with "/"
* url_path_prefix ends with "/"
* web_proxy_url ends with "/" and doesn't contain any path segments

Expected Functionality

* Entries following above rules are injected into action
* Action attempts to findEntryFromUrl incoming request paths against entries
* If findEntryFromUrl found, incoming request path is appended to host + port of StaticResourceEntry.server_url
* Else, 404

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `WebProxyAction(optionalBinder: `[`OptionalBinder`](../-optional-binder/index.md)`, clientHttpCall: ActionScoped<`[`HttpCall`](../../misk.web/-http-call/index.md)`>, staticResourceAction: `[`StaticResourceAction`](../../misk.web.resources/-static-resource-action/index.md)`, resourceEntryFinder: `[`ResourceEntryFinder`](../../misk.web.resources/-resource-entry-finder/index.md)`)`<br>WebProxyAction |

### Functions

| Name | Summary |
|---|---|
| [action](action.md) | `fun action(): Response<ResponseBody>` |

### Extension Functions

| Name | Summary |
|---|---|
| [asChain](../../misk.web.actions/as-chain.md) | `fun WebAction.asChain(function: `[`KFunction`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-function/index.html)`<*>, args: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>, interceptors: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`ApplicationInterceptor`](../../misk/-application-interceptor/index.md)`>): `[`Chain`](../../misk/-chain/index.md) |
