[misk](../../index.md) / [misk.web](../index.md) / [HttpCall](./index.md)

# HttpCall

`interface HttpCall`

A live HTTP call from a client for use by a chain of network interceptors.

### Properties

| Name | Summary |
|---|---|
| [dispatchMechanism](dispatch-mechanism.md) | `abstract val dispatchMechanism: `[`DispatchMechanism`](../-dispatch-mechanism/index.md) |
| [linkLayerLocalAddress](link-layer-local-address.md) | `abstract val linkLayerLocalAddress: `[`SocketAddress`](../-socket-address/index.md)`?` |
| [requestHeaders](request-headers.md) | `abstract val requestHeaders: Headers` |
| [responseHeaders](response-headers.md) | `abstract val responseHeaders: Headers` |
| [statusCode](status-code.md) | `abstract var statusCode: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The HTTP response under construction. |
| [url](url.md) | `abstract val url: HttpUrl`<br>Immutable information about the incoming HTTP request. |

### Functions

| Name | Summary |
|---|---|
| [accepts](accepts.md) | `open fun accepts(): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<MediaRange>` |
| [addResponseHeaders](add-response-headers.md) | `abstract fun addResponseHeaders(headers: Headers): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [asOkHttpRequest](as-ok-http-request.md) | `open fun asOkHttpRequest(): Request` |
| [contentType](content-type.md) | `open fun contentType(): MediaType?` |
| [initWebSocketListener](init-web-socket-listener.md) | `abstract fun initWebSocketListener(webSocketListener: WebSocketListener): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Set the call's web socket listener. This should only be called once, and only for web socket calls. |
| [putRequestBody](put-request-body.md) | `abstract fun putRequestBody(requestBody: BufferedSource): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Changes this call so that the next call to [takeRequestBody](take-request-body.md) returns [requestBody](put-request-body.md#misk.web.HttpCall$putRequestBody(okio.BufferedSource)/requestBody). Use this to apply filters such as decompression or metrics. |
| [putResponseBody](put-response-body.md) | `abstract fun putResponseBody(responseBody: BufferedSink): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Changes this call so that the next call to [takeResponseBody](take-response-body.md) returns [responseBody](put-response-body.md#misk.web.HttpCall$putResponseBody(okio.BufferedSink)/responseBody). Use this to apply filters such as decompression or metrics. |
| [putWebSocket](put-web-socket.md) | `abstract fun putWebSocket(webSocket: WebSocket): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Changes this call so that the next call to [takeWebSocket](take-web-socket.md) returns [webSocket](put-web-socket.md#misk.web.HttpCall$putWebSocket(misk.web.actions.WebSocket)/webSocket). Use this to apply filters such as decompression or metrics. |
| [requireTrailers](require-trailers.md) | `abstract fun requireTrailers(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Call this before the response body is written to make sure it is encoded in a way that'll permit trailers to be sent. This will do chunked encoding for HTTP/1. For HTTP/2 trailers are always permitted. It is an error to call this for web socket calls. |
| [setResponseHeader](set-response-header.md) | `abstract fun setResponseHeader(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setResponseTrailer](set-response-trailer.md) | `abstract fun setResponseTrailer(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Add a trailer. This requires that [requireTrailers](require-trailers.md) was called before the response body is written. |
| [takeRequestBody](take-request-body.md) | `abstract fun takeRequestBody(): BufferedSource?`<br>Claim ownership of the request body stream. Returns null if the stream has already been claimed. Callers should read the HTTP request body or call [putRequestBody](put-request-body.md) to create a new chain with a request body that is unclaimed. |
| [takeResponseBody](take-response-body.md) | `abstract fun takeResponseBody(): BufferedSink?`<br>Claim ownership of the response body stream. Returns null if the stream has already been claimed. Callers should write the HTTP response body or call [putRequestBody](put-request-body.md) to create a new chain with a response body that is unclaimed. |
| [takeWebSocket](take-web-socket.md) | `abstract fun takeWebSocket(): WebSocket?`<br>Claim ownership of the call's web socket. |
